/*
 * Decompiled with CFR 0.152.
 */
package org.simgrid.msg;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.simgrid.msg.Host;
import org.simgrid.msg.HostFailureException;
import org.simgrid.msg.HostNotFoundException;
import org.simgrid.msg.Msg;
import org.simgrid.msg.MsgException;
import org.simgrid.msg.NativeException;
import org.simgrid.msg.ProcessKilledError;

public abstract class Process
implements Runnable {
    private long bind = 0L;
    boolean started;
    public static long nextProcessId = 0L;
    public long id = nextProcessId++;
    public double startTime = 0.0;
    public double killTime = -1.0;
    public Hashtable<String, String> properties = null;
    protected String name = null;
    protected int pid = -1;
    protected int ppid = -1;
    protected Host host = null;
    public Vector<String> args = new Vector();

    protected Process() {
    }

    public Process(String string, String string2) throws HostNotFoundException {
        this(Host.getByName(string), string2, null);
    }

    public Process(String string, String string2, String[] stringArray) throws HostNotFoundException, NativeException {
        this(Host.getByName(string), string2, stringArray);
    }

    public Process(Host host, String string) {
        this(host, string, null);
    }

    public Process(Host host, String string, String[] stringArray) {
        this();
        this.host = host;
        if (string == null) {
            throw new NullPointerException("Process name cannot be NULL");
        }
        this.name = string;
        this.args = new Vector();
        if (null != stringArray) {
            this.args.addAll(Arrays.asList(stringArray));
        }
        this.properties = new Hashtable();
    }

    public Process(Host host, String string, String[] stringArray, double d, double d2) {
        this();
        this.host = host;
        if (string == null) {
            throw new NullPointerException("Process name cannot be NULL");
        }
        this.name = string;
        this.args = new Vector();
        if (null != stringArray) {
            this.args.addAll(Arrays.asList(stringArray));
        }
        this.properties = new Hashtable();
        this.startTime = d;
        this.killTime = d2;
    }

    protected native void create(String var1) throws HostNotFoundException;

    public static native int killAll(int var0);

    public native void kill();

    public native void suspend();

    @Deprecated
    public void pause() {
        this.suspend();
    }

    @Deprecated
    public void restart() {
        this.resume();
    }

    public native void resume();

    public native boolean isSuspended();

    public String msgName() {
        return this.name;
    }

    public Host getHost() {
        return this.host;
    }

    public static native Process fromPID(int var0) throws NativeException;

    public int getPID() {
        return this.pid;
    }

    public int getPPID() {
        return this.ppid;
    }

    public native void setKillTime(double var1);

    public static native Process currentProcess();

    public native void migrate(Host var1);

    public static void sleep(long l) throws HostFailureException {
        Process.sleep(l, 0);
    }

    public static native void sleep(long var0, int var2) throws HostFailureException;

    public native void waitFor(double var1) throws HostFailureException;

    public void showArgs() {
        Msg.info("[" + this.name + "/" + this.getHost().getName() + "] argc=" + this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            Msg.info("[" + this.msgName() + "/" + this.getHost().getName() + "] args[" + i + "]=" + this.args.get(i));
        }
    }

    public final void start() throws HostNotFoundException {
        if (!this.started) {
            this.started = true;
            this.create(this.host.getName());
        }
    }

    @Override
    public void run() {
        String[] stringArray = null;
        try {
            stringArray = new String[this.args.size()];
            if (this.args.size() > 0) {
                this.args.toArray(stringArray);
            }
            this.main(stringArray);
        }
        catch (MsgException msgException) {
            msgException.printStackTrace();
            Msg.info("Unexpected behavior. Stopping now");
            System.exit(1);
        }
        catch (ProcessKilledError processKilledError) {
            // empty catch block
        }
        this.exit();
    }

    public abstract void main(String[] var1) throws MsgException;

    public native void exit();

    public static native void nativeInit();

    static {
        Process.nativeInit();
    }
}

