/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.AbstractMediaWikiLanguage;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.Messages;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor {
    private static final Pattern templatePattern = Pattern.compile("(?:^|(?<!\\{))(\\{\\{(#?[a-zA-Z0-9_ :]+)\\s*(\\|[^\\}]*)?\\}\\})");
    private static final Pattern templateParameterPattern = Pattern.compile("\\{\\{\\{([a-zA-Z0-9]+)(?:\\|([^\\}]*))?\\}\\}\\}");
    private static final Pattern parameterSpec = Pattern.compile("\\|\\s*([^\\|=]+)(?:\\s*=\\s*(([^|]*)))?");
    private static final Pattern includeOnlyPattern = Pattern.compile(".*?<includeonly>(.*?)</includeonly>.*", 32);
    private static final Pattern noIncludePattern = Pattern.compile("<noinclude>(.*?)</noinclude>", 32);
    private final AbstractMediaWikiLanguage mediaWikiLanguage;
    private final Map<String, Template> templateByName = new HashMap<String, Template>();
    private final List<Pattern> excludePatterns = new ArrayList<Pattern>();

    public TemplateProcessor(AbstractMediaWikiLanguage abstractMediaWikiLanguage) {
        this.mediaWikiLanguage = abstractMediaWikiLanguage;
        for (Template template : this.mediaWikiLanguage.getTemplates()) {
            this.templateByName.put(template.getName(), this.normalize(template));
        }
        String templateExcludes = abstractMediaWikiLanguage.getTemplateExcludes();
        if (templateExcludes != null) {
            String[] split;
            String[] stringArray = split = templateExcludes.split("\\s*,\\s*");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                String pattern = exclude.replaceAll("([^a-zA-Z:\\*])", "\\\\$1").replaceAll("\\*", ".*?");
                this.excludePatterns.add(Pattern.compile(pattern, 2));
                ++n2;
            }
        }
    }

    public String processTemplates(String markupContent) {
        return this.processTemplates(markupContent, Collections.<String>emptySet());
    }

    private String processTemplates(String markupContent, Set<String> usedTemplates) {
        StringBuilder processedMarkup = new StringBuilder();
        int lastIndex = 0;
        Matcher matcher = templatePattern.matcher(markupContent);
        while (matcher.find()) {
            String templateName;
            Template template;
            int start = matcher.start();
            if (lastIndex < start) {
                processedMarkup.append(markupContent.substring(lastIndex, start));
            }
            if ((template = this.resolveTemplate(templateName = matcher.group(2))) != null) {
                String replacementText;
                if (usedTemplates.contains(templateName)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<span class=\"error\">");
                    sb.append(MessageFormat.format(Messages.getString("TemplateProcessor_loopDetected"), template.getName()));
                    sb.append("</span>");
                    replacementText = sb.toString();
                } else {
                    String parameters = matcher.group(3);
                    replacementText = this.processTemplate(template, parameters);
                    HashSet<String> templates = new HashSet<String>(usedTemplates);
                    templates.add(templateName);
                    replacementText = this.processTemplates(replacementText, templates);
                }
                replacementText = this.processTemplates(replacementText);
                processedMarkup.append(replacementText);
            }
            lastIndex = matcher.end();
        }
        if (lastIndex == 0) {
            return markupContent;
        }
        if (lastIndex < markupContent.length()) {
            processedMarkup.append(markupContent.substring(lastIndex));
        }
        return processedMarkup.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String processTemplate(Template template, String parametersText) {
        if (template.getTemplateMarkup() == null) {
            return "";
        }
        macro = template.getTemplateContent();
        parameters = this.processParameters(parametersText);
        processedMarkup = new StringBuilder();
        lastIndex = 0;
        matcher = TemplateProcessor.templateParameterPattern.matcher(macro);
        while (matcher.find()) {
            block9: {
                start = matcher.start();
                if (lastIndex < start) {
                    processedMarkup.append(macro.substring(lastIndex, start));
                }
                parameterName = matcher.group(1);
                parameterValue = matcher.group(2);
                try {
                    parameterIndex = Integer.parseInt(parameterName);
                    if (parameterIndex > parameters.size() || parameterIndex <= 0) break block9;
                    parameterValue = parameters.get((int)(parameterIndex - 1)).value;
                    break block9;
                }
                catch (NumberFormatException v0) {
                    ** for (param : parameters)
                }
lbl-1000:
                // 1 sources

                {
                    if (!parameterName.equalsIgnoreCase(param.name)) continue;
                    parameterValue = param.value;
                    break;
                }
            }
            if (parameterValue != null) {
                processedMarkup.append(parameterValue);
            }
            lastIndex = matcher.end();
        }
        if (lastIndex == 0) {
            return macro;
        }
        if (lastIndex < macro.length()) {
            processedMarkup.append(macro.substring(lastIndex));
        }
        return processedMarkup.toString();
    }

    private List<Parameter> processParameters(String parametersText) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (parametersText != null && parametersText.length() > 0) {
            Matcher matcher = parameterSpec.matcher(parametersText);
            while (matcher.find()) {
                String nameOrValue = matcher.group(1);
                String value = matcher.group(2);
                Parameter parameter = new Parameter();
                if (value != null) {
                    parameter.name = nameOrValue;
                    parameter.value = value;
                } else {
                    parameter.value = nameOrValue;
                }
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    private Template resolveTemplate(String templateName) {
        Template template;
        if (!this.excludePatterns.isEmpty()) {
            for (Pattern p : this.excludePatterns) {
                if (!p.matcher(templateName).matches()) continue;
                return null;
            }
        }
        if ((template = this.templateByName.get(templateName)) == null) {
            for (TemplateResolver resolver : this.mediaWikiLanguage.getTemplateProviders()) {
                template = resolver.resolveTemplate(templateName);
                if (template == null) continue;
                template = this.normalize(template);
                break;
            }
            if (template == null) {
                template = new Template();
                template.setName(templateName);
                template.setTemplateMarkup("");
            }
            this.templateByName.put(template.getName(), template);
        }
        return template;
    }

    private Template normalize(Template template) {
        Template normalizedTemplate = new Template();
        normalizedTemplate.setName(template.getName());
        normalizedTemplate.setTemplateMarkup(this.normalizeTemplateMarkup(template.getTemplateContent()));
        return normalizedTemplate;
    }

    private String normalizeTemplateMarkup(String templateMarkup) {
        Matcher matcher = includeOnlyPattern.matcher(templateMarkup);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = noIncludePattern.matcher(templateMarkup);
        return matcher.replaceAll("");
    }

    private static class Parameter {
        String name;
        String value;

        private Parameter() {
        }
    }
}

