/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import java.util.Arrays;

public final class EncryptedData {
    public final byte[] initialisationVector;
    public final byte[] encryptedBytes;

    public EncryptedData(byte[] initialisationVector, byte[] encryptedBytes) {
        this.initialisationVector = Arrays.copyOf(initialisationVector, initialisationVector.length);
        this.encryptedBytes = Arrays.copyOf(encryptedBytes, encryptedBytes.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedData that = (EncryptedData)o;
        return Arrays.equals(this.encryptedBytes, that.encryptedBytes) && Arrays.equals(this.initialisationVector, that.initialisationVector);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.initialisationVector);
        result = 31 * result + Arrays.hashCode(this.encryptedBytes);
        return result;
    }

    public String toString() {
        return "EncryptedData [initialisationVector=" + Arrays.toString(this.initialisationVector) + ", encryptedPrivateKey=" + Arrays.toString(this.encryptedBytes) + "]";
    }
}

