/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.UnsafeByteArrayOutputStream;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.core.VersionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    private static final long serialVersionUID = -3561053461717079135L;
    public static final int MAX_SIZE = 0x2000000;
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final boolean SELF_CHECK = false;
    protected transient int offset;
    protected transient int cursor;
    protected transient int length = Integer.MIN_VALUE;
    protected transient byte[] payload;
    protected transient boolean parsed = false;
    protected transient boolean recached = false;
    protected final transient boolean parseLazy;
    protected final transient boolean parseRetain;
    protected transient int protocolVersion;
    protected transient byte[] checksum;
    protected NetworkParameters params;

    protected Message() {
        this.parsed = true;
        this.parseLazy = false;
        this.parseRetain = false;
    }

    Message(NetworkParameters params) {
        this.params = params;
        this.parsed = true;
        this.parseLazy = false;
        this.parseRetain = false;
    }

    Message(NetworkParameters params, byte[] payload, int offset, int protocolVersion) throws ProtocolException {
        this(params, payload, offset, protocolVersion, false, false, Integer.MIN_VALUE);
    }

    Message(NetworkParameters params, byte[] payload, int offset, int protocolVersion, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        this.parseLazy = parseLazy;
        this.parseRetain = parseRetain;
        this.protocolVersion = protocolVersion;
        this.params = params;
        this.payload = payload;
        this.cursor = this.offset = offset;
        this.length = length;
        if (parseLazy) {
            this.parseLite();
        } else {
            this.parseLite();
            this.parse();
            this.parsed = true;
        }
        if (this.length == Integer.MIN_VALUE) {
            Preconditions.checkState((boolean)false, (String)"Length field has not been set in constructor for %s after %s parse. Refer to Message.parseLite() for detail of required Length field contract.", (Object[])new Object[]{this.getClass().getSimpleName(), parseLazy ? "lite" : "full"});
        }
        if (parseRetain || !this.parsed) {
            return;
        }
        this.payload = null;
    }

    private void selfCheck(byte[] payload, int offset) {
        if (!(this instanceof VersionMessage)) {
            this.maybeParse();
            byte[] payloadBytes = new byte[this.cursor - offset];
            System.arraycopy(payload, offset, payloadBytes, 0, this.cursor - offset);
            byte[] reserialized = this.bitcoinSerialize();
            if (!Arrays.equals(reserialized, payloadBytes)) {
                throw new RuntimeException("Serialization is wrong: \n" + Utils.HEX.encode(reserialized) + " vs \n" + Utils.HEX.encode(payloadBytes));
            }
        }
    }

    Message(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        this(params, payload, offset, 70001, false, false, Integer.MIN_VALUE);
    }

    Message(NetworkParameters params, byte[] payload, int offset, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        this(params, payload, offset, 70001, parseLazy, parseRetain, length);
    }

    abstract void parse() throws ProtocolException;

    protected abstract void parseLite() throws ProtocolException;

    protected synchronized void maybeParse() {
        if (this.parsed || this.payload == null) {
            return;
        }
        try {
            this.parse();
            this.parsed = true;
            if (!this.parseRetain) {
                this.payload = null;
            }
        }
        catch (ProtocolException e) {
            throw new LazyParseException("ProtocolException caught during lazy parse.  For safe access to fields call ensureParsed before attempting read or write access", e);
        }
    }

    public void ensureParsed() throws ProtocolException {
        try {
            this.maybeParse();
        }
        catch (LazyParseException e) {
            if (e.getCause() instanceof ProtocolException) {
                throw (ProtocolException)e.getCause();
            }
            throw new ProtocolException(e);
        }
    }

    protected void unCache() {
        this.maybeParse();
        this.checksum = null;
        this.payload = null;
        this.recached = false;
    }

    protected void adjustLength(int newArraySize, int adjustment) {
        if (this.length == Integer.MIN_VALUE) {
            return;
        }
        if (adjustment == Integer.MIN_VALUE) {
            this.length = Integer.MIN_VALUE;
            return;
        }
        this.length += adjustment;
        if (newArraySize == 1) {
            ++this.length;
        } else if (newArraySize != 0) {
            this.length += VarInt.sizeOf(newArraySize) - VarInt.sizeOf(newArraySize - 1);
        }
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public boolean isCached() {
        return this.payload != null;
    }

    public boolean isRecached() {
        return this.recached;
    }

    byte[] getChecksum() {
        return this.checksum;
    }

    void setChecksum(byte[] checksum) {
        if (checksum.length != 4) {
            throw new IllegalArgumentException("Checksum length must be 4 bytes, actual length: " + checksum.length);
        }
        this.checksum = checksum;
    }

    public byte[] bitcoinSerialize() {
        byte[] bytes = this.unsafeBitcoinSerialize();
        byte[] copy = new byte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        return copy;
    }

    public byte[] unsafeBitcoinSerialize() {
        if (this.payload != null) {
            if (this.offset == 0 && this.length == this.payload.length) {
                return this.payload;
            }
            byte[] buf = new byte[this.length];
            System.arraycopy(this.payload, this.offset, buf, 0, this.length);
            return buf;
        }
        UnsafeByteArrayOutputStream stream = new UnsafeByteArrayOutputStream(this.length < 32 ? 32 : this.length + 32);
        try {
            this.bitcoinSerializeToStream(stream);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.parseRetain) {
            this.payload = ((ByteArrayOutputStream)stream).toByteArray();
            this.cursor -= this.offset;
            this.offset = 0;
            this.recached = true;
            this.length = this.payload.length;
            return this.payload;
        }
        byte[] buf = ((ByteArrayOutputStream)stream).toByteArray();
        this.length = buf.length;
        return buf;
    }

    public final void bitcoinSerialize(OutputStream stream) throws IOException {
        if (this.payload != null && this.length != Integer.MIN_VALUE) {
            stream.write(this.payload, this.offset, this.length);
            return;
        }
        this.bitcoinSerializeToStream(stream);
    }

    void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        log.error("Error: {} class has not implemented bitcoinSerializeToStream method.  Generating message with no payload", this.getClass());
    }

    public Sha256Hash getHash() {
        throw new UnsupportedOperationException();
    }

    public int getMessageSize() {
        if (this.length != Integer.MIN_VALUE) {
            return this.length;
        }
        this.maybeParse();
        if (this.length == Integer.MIN_VALUE) {
            Preconditions.checkState((boolean)false, (String)"Length field has not been set in %s after full parse.", (Object[])new Object[]{this.getClass().getSimpleName()});
        }
        return this.length;
    }

    long readUint32() throws ProtocolException {
        try {
            long u = Utils.readUint32(this.payload, this.cursor);
            this.cursor += 4;
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ProtocolException(e);
        }
    }

    long readInt64() throws ProtocolException {
        try {
            long u = Utils.readInt64(this.payload, this.cursor);
            this.cursor += 8;
            return u;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ProtocolException(e);
        }
    }

    BigInteger readUint64() throws ProtocolException {
        return new BigInteger(Utils.reverseBytes(this.readBytes(8)));
    }

    long readVarInt() throws ProtocolException {
        return this.readVarInt(0);
    }

    long readVarInt(int offset) throws ProtocolException {
        try {
            VarInt varint = new VarInt(this.payload, this.cursor + offset);
            this.cursor += offset + varint.getOriginalSizeInBytes();
            return varint.value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ProtocolException(e);
        }
    }

    byte[] readBytes(int length) throws ProtocolException {
        if (length > 0x2000000) {
            throw new ProtocolException("Claimed value length too large: " + length);
        }
        try {
            byte[] b = new byte[length];
            System.arraycopy(this.payload, this.cursor, b, 0, length);
            this.cursor += length;
            return b;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException(e);
        }
    }

    byte[] readByteArray() throws ProtocolException {
        long len = this.readVarInt();
        return this.readBytes((int)len);
    }

    String readStr() throws ProtocolException {
        long length = this.readVarInt();
        return length == 0L ? "" : Utils.toString(this.readBytes((int)length), "UTF-8");
    }

    Sha256Hash readHash() throws ProtocolException {
        return Sha256Hash.wrapReversed(this.readBytes(32));
    }

    boolean hasMoreBytes() {
        return this.cursor < this.payload.length;
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    public static class LazyParseException
    extends RuntimeException {
        private static final long serialVersionUID = 6971943053112975594L;

        public LazyParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public LazyParseException(String message) {
            super(message);
        }
    }
}

