/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.Set;
import net.tomp2p.peers.Number160;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.PeerTracker;
import net.tomp2p.tracker.TrackerBuilder;

public class GetTrackerBuilder
extends TrackerBuilder<GetTrackerBuilder> {
    private Set<Number160> knownPeers;
    private boolean expectAttachement = false;

    public GetTrackerBuilder(PeerTracker peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public boolean isExpectAttachement() {
        return this.expectAttachement;
    }

    public GetTrackerBuilder expectAttachement() {
        this.expectAttachement = true;
        return this;
    }

    public GetTrackerBuilder expectAttachement(boolean expectAttachement) {
        this.expectAttachement = expectAttachement;
        return this;
    }

    @Override
    public FutureTracker start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_TRACKER_SHUTDOWN;
        }
        if (!this.expectAttachement) {
            this.forceUDP(true);
        }
        this.preBuild("get-tracker-builder");
        if (this.knownPeers == null) {
            this.knownPeers = new SimpleBloomFilter(1024, 1024);
        }
        return this.peer.distributedTracker().get(this);
    }
}

