/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class FutureTracker
extends BaseFutureImpl<FutureTracker> {
    private final Set<Number160> knownPeers;
    private Set<PeerAddress> potentialTrackers;
    private Set<PeerAddress> directTrackers;
    private Map<PeerAddress, TrackerData> peersOnTracker;
    private FutureDone<Void> futureDone;

    public FutureTracker() {
        this(null);
    }

    public FutureTracker(Set<Number160> knownPeers) {
        this.knownPeers = knownPeers;
        this.self((BaseFuture)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackers(Set<PeerAddress> potentialTrackers, Set<PeerAddress> directTrackers, Map<PeerAddress, TrackerData> peersOnTracker, FutureDone<Void> futureDone) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return;
            }
            this.potentialTrackers = potentialTrackers;
            this.directTrackers = directTrackers;
            this.peersOnTracker = peersOnTracker;
            this.futureDone = futureDone;
            BaseFuture.FutureType futureType = this.type = potentialTrackers.size() == 0 && directTrackers.size() == 0 ? BaseFuture.FutureType.FAILED : BaseFuture.FutureType.OK;
            if (this.type == BaseFuture.FutureType.FAILED) {
                this.reason = "we did not find anything, are you sure you are serching for the right tracker?";
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> potentialTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.potentialTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> directTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.directTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, TrackerData> rawPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<PeerAddress> peersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> trackerPeers() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Number160> knownPeers() {
        Object object = this.lock;
        synchronized (object) {
            return this.knownPeers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TrackerData> trackerData() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PeerAddress> trackers() {
        HashSet<PeerAddress> retVal = new HashSet<PeerAddress>();
        Object object = this.lock;
        synchronized (object) {
            for (TrackerData trackerData : this.peersOnTracker.values()) {
                retVal.addAll(trackerData.peerAddresses().keySet());
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Data> trackerMap() {
        HashMap<PeerAddress, Data> retVal = new HashMap<PeerAddress, Data>();
        Object object = this.lock;
        synchronized (object) {
            for (TrackerData trackerData : this.peersOnTracker.values()) {
                retVal.putAll(trackerData.peerAddresses());
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureDone<Void> futuresCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureDone;
        }
    }
}

