/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.tracker.AddTrackerBuilder;
import net.tomp2p.tracker.GetTrackerBuilder;
import net.tomp2p.tracker.TrackerStorage;
import net.tomp2p.tracker.UtilsTracker;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerRPC.class);
    public static final int MAX_MSG_SIZE_UDP = 35;
    private final TrackerStorage trackerStorage;

    public TrackerRPC(PeerBean peerBean, ConnectionBean connectionBean, TrackerStorage trackerStorage) {
        super(peerBean, connectionBean);
        this.register(new int[]{RPC.Commands.TRACKER_ADD.getNr(), RPC.Commands.TRACKER_GET.getNr()});
        this.trackerStorage = trackerStorage;
    }

    public FutureResponse addToTracker(PeerAddress remotePeer, AddTrackerBuilder builder, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer, builder.locationKey(), builder.domainKey()});
        Message message = this.createMessage(remotePeer, RPC.Commands.TRACKER_ADD.getNr(), Message.Type.REQUEST_3);
        if (builder.isSign()) {
            message.publicKeyAndSign(builder.keyPair());
        }
        message.key(builder.locationKey());
        message.key(builder.domainKey());
        if (builder.getBloomFilter() != null) {
            message.bloomFilter(builder.getBloomFilter());
        }
        FutureResponse futureResponse = new FutureResponse(message);
        this.addTrackerDataListener(futureResponse, new Number320(builder.locationKey(), builder.domainKey()), message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)builder);
        TrackerData trackerData = new TrackerData(new HashMap());
        PeerAddress peerAddressToAnnounce = builder.peerAddressToAnnounce();
        if (peerAddressToAnnounce == null) {
            peerAddressToAnnounce = this.peerBean().serverPeerAddress();
        }
        trackerData.put(peerAddressToAnnounce, builder.attachement());
        trackerData = UtilsTracker.limit(trackerData, 35);
        message.trackerData(trackerData);
        LOG.debug("tracker PUT {}", (Object)message);
        if (builder.isForceTCP() || builder.attachement() != null) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.sendUDP(channelCreator);
    }

    public FutureResponse getFromTracker(PeerAddress remotePeer, GetTrackerBuilder builder, ChannelCreator channelCreator) {
        Utils.nullCheck((Object[])new Object[]{remotePeer, builder.locationKey(), builder.domainKey()});
        Message message = this.createMessage(remotePeer, RPC.Commands.TRACKER_GET.getNr(), Message.Type.REQUEST_1);
        if (builder.isSign()) {
            message.publicKeyAndSign(builder.keyPair());
        }
        message.key(builder.locationKey());
        message.key(builder.domainKey());
        if (builder.knownPeers() != null && builder.knownPeers() instanceof SimpleBloomFilter) {
            message.bloomFilter((SimpleBloomFilter)builder.knownPeers());
        }
        FutureResponse futureResponse = new FutureResponse(message);
        this.addTrackerDataListener(futureResponse, new Number320(builder.locationKey(), builder.domainKey()), message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)builder);
        LOG.debug("tracker GET {}", (Object)message);
        if (builder.isExpectAttachement() || builder.isForceTCP()) {
            return requestHandler.sendTCP(channelCreator);
        }
        return requestHandler.sendUDP(channelCreator);
    }

    private void addTrackerDataListener(FutureResponse futureResponse, final Number320 key, final Message message) {
        futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    Message message2 = future.responseMessage();
                    TrackerData tmp = message2.trackerData(0);
                    if (tmp == null || tmp.size() == 0) {
                        return;
                    }
                    for (Map.Entry trackerData : tmp.peerAddresses().entrySet()) {
                        TrackerRPC.this.trackerStorage.put(key, (PeerAddress)trackerData.getKey(), null, (Data)trackerData.getValue());
                    }
                } else {
                    LOG.warn("add tracker failed: msg = {}, {}", (Object)message, (Object)future.failedReason());
                }
            }
        });
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.debug("handleResponse on {}", (Object)message);
        if (message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_3 || message.key(0) == null || message.key(1) == null) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        SimpleBloomFilter knownPeers = message.bloomFilter(0);
        PublicKey publicKey = message.publicKey(0);
        Collection<Pair<PeerStatistic, Data>> value = this.trackerStorage.peers(new Number320(locationKey, domainKey)).values();
        TrackerData meshPeers = new TrackerData(value);
        LOG.debug("found peers on tracker: {}", meshPeers == null ? "null " : meshPeers.peerAddresses());
        boolean couldProvideMoreData = false;
        if (meshPeers != null) {
            int size;
            if (knownPeers != null) {
                meshPeers = UtilsTracker.disjunction(meshPeers, (SimpleBloomFilter<Number160>)knownPeers);
            }
            couldProvideMoreData = (size = meshPeers.size()) > (meshPeers = UtilsTracker.limit(meshPeers, 35)).size();
            responseMessage.trackerData(meshPeers);
        }
        if (couldProvideMoreData) {
            responseMessage.type(Message.Type.PARTIALLY_OK);
        }
        if (message.command() == RPC.Commands.TRACKER_ADD.getNr()) {
            TrackerData trackerData = message.trackerData(0);
            if (trackerData.size() != 1) {
                responseMessage.type(Message.Type.EXCEPTION);
            } else {
                Map.Entry entry = trackerData.peerAddresses().entrySet().iterator().next();
                if (!this.trackerStorage.put(new Number320(locationKey, domainKey), (PeerAddress)entry.getKey(), publicKey, (Data)entry.getValue())) {
                    responseMessage.type(Message.Type.DENIED);
                    LOG.debug("tracker NOT put on({}) locationKey:{}, domainKey:{}, address:{}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, entry.getKey()});
                } else {
                    LOG.debug("tracker put on({}) locationKey:{}, domainKey:{}, address: {}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, entry.getKey()});
                }
            }
        } else {
            LOG.debug("tracker get on({}) locationKey:{}, domainKey:{}, address:{}, returning: {}", new Object[]{this.peerBean().serverPeerAddress(), locationKey, domainKey, message.sender(), meshPeers == null ? "0" : Integer.valueOf(meshPeers.size())});
        }
        if (sign) {
            responseMessage.publicKeyAndSign(this.peerBean().getKeyPair());
        }
        responder.response(responseMessage);
    }
}

