/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.p2p.RequestConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMapFilter;
import net.tomp2p.tracker.FutureTracker;
import net.tomp2p.tracker.PeerTracker;
import net.tomp2p.tracker.TrackerConfiguration;

public abstract class TrackerBuilder<K extends TrackerBuilder<K>>
extends DefaultConnectionConfiguration
implements SignatureBuilder<K>,
Builder {
    public static final Number160 DEFAULT_DOMAIN = Number160.createHash((String)"default-tracker");
    protected static final FutureTracker FUTURE_TRACKER_SHUTDOWN = (FutureTracker)new FutureTracker().failed("Peer is shutting down");
    protected final PeerTracker peer;
    protected final Number160 locationKey;
    protected Number160 domainKey;
    protected RoutingConfiguration routingConfiguration;
    protected TrackerConfiguration trackerConfiguration;
    protected FutureChannelCreator futureChannelCreator;
    private Set<Number160> knownPeers;
    private K self;
    private KeyPair keyPair = null;
    private Collection<PeerMapFilter> peerMapFilters;

    public TrackerBuilder(PeerTracker peer, Number160 locationKey) {
        this.peer = peer;
        this.locationKey = locationKey;
    }

    public void self(K self) {
        this.self = self;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public K domainKey(Number160 domainKey) {
        this.domainKey = domainKey;
        return this.self;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public K routingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this.self;
    }

    public TrackerConfiguration trackerConfiguration() {
        return this.trackerConfiguration;
    }

    public K trackerConfiguration(TrackerConfiguration trackerConfiguration) {
        this.trackerConfiguration = trackerConfiguration;
        return this.self;
    }

    public FutureChannelCreator futureChannelCreator() {
        return this.futureChannelCreator;
    }

    public K futureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this.self;
    }

    public Set<Number160> knownPeers() {
        return this.knownPeers;
    }

    public K knownPeers(Set<Number160> knownPeers) {
        this.knownPeers = knownPeers;
        return this.self;
    }

    public void preBuild(String name) {
        if (this.domainKey == null) {
            this.domainKey = DEFAULT_DOMAIN;
        }
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(5, 10, 2);
        }
        if (this.trackerConfiguration == null) {
            int size = this.peer.peerMap().size() + 1;
            this.trackerConfiguration = new TrackerConfiguration(Math.min(size, 3), 5, 3, 30);
        }
        if (this.futureChannelCreator == null || this.futureChannelCreator.channelCreator() != null && this.futureChannelCreator.channelCreator().isShutdown()) {
            this.futureChannelCreator = this.peer.peer().connectionBean().reservation().create(this.routingConfiguration, (RequestConfiguration)this.trackerConfiguration, (DefaultConnectionConfiguration)this);
        }
    }

    public abstract FutureTracker start();

    public RoutingBuilder createBuilder(RoutingConfiguration routingConfiguration2) {
        RoutingBuilder routingBuilder = new RoutingBuilder();
        routingBuilder.parallel(this.routingConfiguration.parallel());
        routingBuilder.setMaxNoNewInfo(this.routingConfiguration.maxNoNewInfo(0));
        routingBuilder.maxDirectHits(this.routingConfiguration.maxDirectHits());
        routingBuilder.maxFailures(this.routingConfiguration.maxFailures());
        routingBuilder.maxSuccess(this.routingConfiguration.maxSuccess());
        return routingBuilder;
    }

    public boolean isSign() {
        return this.keyPair != null;
    }

    public K sign(boolean signMessage) {
        if (signMessage) {
            this.sign();
        } else {
            this.keyPair = null;
        }
        return this.self;
    }

    public K sign() {
        this.keyPair = this.peer.peer().peerBean().keyPair();
        return this.self;
    }

    public K keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this.self;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public K addPeerMapFilter(PeerMapFilter peerMapFilter) {
        if (this.peerMapFilters == null) {
            this.peerMapFilters = new ArrayList<PeerMapFilter>(2);
        }
        this.peerMapFilters.add(peerMapFilter);
        return this.self;
    }

    public Collection<PeerMapFilter> peerMapFilters() {
        return this.peerMapFilters;
    }
}

