/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import net.tomp2p.p2p.RequestConfiguration;

public class TrackerConfiguration
implements RequestConfiguration {
    private final int maxFailure;
    private final int parallel;
    private final int atLeastSuccessfulRequests;
    private final int atLeastEntriesFromTrackers;
    private final int maxFullTrackers;
    private final int maxPrimaryTrackers;
    private final boolean forceUPD;
    private final boolean forceTCP;

    public TrackerConfiguration(int maxFailure, int parallel, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers) {
        this(maxFailure, parallel, atLeastSuccessfulRequests, atLeastEntriesFromTrackers, 20, 5);
    }

    public TrackerConfiguration(int maxFailure, int parallel, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers, int maxFullTrackers, int maxPrimaryTrackers) {
        this(maxFailure, parallel, atLeastSuccessfulRequests, atLeastEntriesFromTrackers, maxFullTrackers, maxPrimaryTrackers, false, false);
    }

    public TrackerConfiguration(int maxFailure, int parallel, int atLeastSuccessfulRequests, int atLeastEntriesFromTrackers, int maxFullTrackers, int maxPrimaryTrackers, boolean forceUDP, boolean forceTCP) {
        if (maxFailure < 0 || parallel < 0 || atLeastSuccessfulRequests < 0 || atLeastEntriesFromTrackers < 0) {
            throw new IllegalArgumentException("need to be larger or equals zero");
        }
        this.maxFailure = maxFailure;
        this.parallel = parallel;
        this.atLeastSuccessfulRequests = atLeastSuccessfulRequests;
        this.atLeastEntriesFromTrackers = atLeastEntriesFromTrackers;
        this.maxFullTrackers = maxFullTrackers;
        this.maxPrimaryTrackers = maxPrimaryTrackers;
        this.forceUPD = forceUDP;
        this.forceTCP = forceTCP;
    }

    public int maxFailure() {
        return this.maxFailure;
    }

    public int parallel() {
        return this.parallel;
    }

    public int atLeastSucessfulRequestes() {
        return this.atLeastSuccessfulRequests;
    }

    public int atLeastEntriesFromTrackers() {
        return this.atLeastEntriesFromTrackers;
    }

    public int maxFullTrackers() {
        return this.maxFullTrackers;
    }

    public int maxPrimaryTrackers() {
        return this.maxPrimaryTrackers;
    }

    public boolean isForceUPD() {
        return this.forceUPD;
    }

    public boolean isForceTCP() {
        return this.forceTCP;
    }
}

