/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestTracker;
import net.tomp2p.tracker.PeerExchange;
import net.tomp2p.utils.ConcurrentCacheMap;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorage
implements Maintainable,
PeerMapChangeListener,
PeerStatusListener,
DigestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TrackerStorage.class);
    public static final int TRACKER_CACHE_SIZE = 1000;
    private final Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> dataMapUnverified;
    private final Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> dataMap;
    private final ConcurrentCacheMap<Number160, Boolean> peerOffline;
    private final boolean verifyPeersOnTracker;
    private final int[] intervalSeconds;
    private final PeerAddress self;
    private final int trackerTimoutSeconds;
    private final PeerMap peerMap;
    private final int replicationFactor;
    private PeerExchange peerExchange;

    public TrackerStorage(int trackerTimoutSeconds, int[] intervalSeconds, int replicationFactor, PeerMap peerMap, PeerAddress self, boolean verifyPeersOnTracker) {
        this.dataMapUnverified = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.dataMap = new ConcurrentCacheMap(trackerTimoutSeconds, 1000, true);
        this.peerOffline = new ConcurrentCacheMap(trackerTimoutSeconds * 5, 1000, false);
        this.trackerTimoutSeconds = trackerTimoutSeconds;
        this.intervalSeconds = intervalSeconds;
        this.self = self;
        this.peerMap = peerMap;
        this.replicationFactor = replicationFactor;
        this.verifyPeersOnTracker = verifyPeersOnTracker;
    }

    public boolean put(Number320 key, PeerAddress peerAddress, PublicKey publicKey, Data attachement) {
        if (this.peerOffline.containsKey((Object)peerAddress.peerId())) {
            return false;
        }
        Pair<PeerStatistic, Data> pair = this.findOld(key, peerAddress, this.dataMapUnverified);
        Data oldDataUnverified = pair != null ? (Data)pair.element1() : null;
        boolean isUnverified = false;
        boolean isVerified = false;
        if (oldDataUnverified != null) {
            if (oldDataUnverified.publicKey() != null && !oldDataUnverified.publicKey().equals(publicKey)) {
                return false;
            }
            isUnverified = true;
        } else {
            Data oldData;
            Pair<PeerStatistic, Data> pair2 = this.findOld(key, peerAddress, this.dataMap);
            Data data = oldData = pair2 != null ? (Data)pair2.element1() : null;
            if (oldData != null) {
                if (oldData.publicKey() != null && !oldData.publicKey().equals(publicKey)) {
                    return false;
                }
                isVerified = true;
            }
        }
        if (attachement == null) {
            attachement = new Data();
        }
        attachement.publicKey(publicKey);
        Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> dataMapToStore = isUnverified ? this.dataMapUnverified : (isVerified ? this.dataMap : (this.verifyPeersOnTracker ? this.dataMapUnverified : this.dataMap));
        return this.add(key, peerAddress, dataMapToStore, attachement);
    }

    private Pair<PeerStatistic, Data> findOld(Number320 key, PeerAddress peerAddress, Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> dataMap) {
        Map<PeerAddress, Pair<PeerStatistic, Data>> map = dataMap.get(key);
        if (map == null) {
            return null;
        }
        Pair<PeerStatistic, Data> pair = map.get(peerAddress);
        if (pair == null) {
            return null;
        }
        return pair;
    }

    public PeerExchange peerExchange() {
        return this.peerExchange;
    }

    public TrackerStorage peerExchange(PeerExchange peerExchange) {
        this.peerExchange = peerExchange;
        return this;
    }

    public PeerStatistic nextForMaintenance(Collection<PeerAddress> notInterestedAddresses) {
        for (Map<PeerAddress, Pair<PeerStatistic, Data>> map2 : this.dataMapUnverified.values()) {
            for (Pair<PeerStatistic, Data> pair : map2.values()) {
                if (!DefaultMaintenance.needMaintenance((PeerStatistic)((PeerStatistic)pair.element0()), (int[])this.intervalSeconds)) continue;
                return (PeerStatistic)pair.element0();
            }
        }
        return null;
    }

    public void peerInserted(PeerAddress remotePeer, boolean verified) {
        if (verified) {
            for (Map.Entry<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> entry : this.dataMap.entrySet()) {
                if (!this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor) || !this.isInReplicationRange(entry.getKey().locationKey(), this.self, this.replicationFactor)) continue;
                TrackerData trackerData = new TrackerData(entry.getValue().values());
                LOG.debug("other peer is closer, send data {} to peer {}", (Object)trackerData, (Object)remotePeer);
                this.peerExchange.peerExchange(remotePeer, entry.getKey(), trackerData);
            }
        }
    }

    public void peerRemoved(PeerAddress remotePeer, PeerStatistic storedPeerAddress) {
        for (Map.Entry<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> entry : this.dataMap.entrySet()) {
            if (!this.isInReplicationRange(entry.getKey().locationKey(), remotePeer, this.replicationFactor) || !this.isInReplicationRange(entry.getKey().locationKey(), this.self, this.replicationFactor)) continue;
            NavigableSet closePeers = this.peerMap.closePeers(entry.getKey().locationKey(), this.replicationFactor);
            PeerAddress newResponsible = closePeers.headSet(remotePeer).last();
            TrackerData trackerData = new TrackerData(entry.getValue().values());
            LOG.debug("other peer left, make sure we have enough copies {}, send to peer {}", (Object)trackerData, (Object)remotePeer);
            this.peerExchange.peerExchange(newResponsible, entry.getKey(), trackerData);
        }
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatistic storedPeerAddress) {
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        tmp.add(this.self);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }

    private boolean add(Number320 key, PeerAddress peerAddress, Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> map, Data attachement) {
        ConcurrentCacheMap map2 = map.get(key);
        if (map2 != null && map2.size() > 1000) {
            return false;
        }
        Pair trackerData = this.findOld(key, peerAddress, map);
        if (trackerData == null) {
            trackerData = new Pair((Object)new PeerStatistic(peerAddress), (Object)attachement);
        }
        if (map2 == null) {
            map2 = new ConcurrentCacheMap(this.trackerTimoutSeconds, 1000, true);
            map.put(key, (Map<PeerAddress, Pair<PeerStatistic, Data>>)map2);
        }
        map2.put((PeerAddress)peerAddress, trackerData);
        return true;
    }

    public Collection<Number320> keys() {
        return this.dataMap.keySet();
    }

    public boolean peerFailed(PeerAddress remotePeer, PeerException reason) {
        this.peerOffline.put((Object)remotePeer.peerId(), (Object)Boolean.TRUE);
        boolean removed = false;
        removed = !this.removeFromMap(remotePeer, this.dataMapUnverified).isEmpty();
        removed = !this.removeFromMap(remotePeer, this.dataMap).isEmpty() || removed;
        return removed;
    }

    private Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> removeFromMap(PeerAddress remotePeer, Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> map) {
        HashMap<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> removed = new HashMap<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>>();
        for (Map.Entry<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> entry : map.entrySet()) {
            Pair<PeerStatistic, Data> oldPair = entry.getValue().remove(remotePeer);
            if (oldPair != null) {
                ConcurrentCacheMap map2 = new ConcurrentCacheMap(this.trackerTimoutSeconds, 1000, true);
                map2.put(remotePeer, oldPair);
                removed.put(entry.getKey(), (Map<PeerAddress, Pair<PeerStatistic, Data>>)map2);
            }
            if (!entry.getValue().isEmpty()) continue;
            map.remove(entry.getKey());
        }
        return removed;
    }

    public boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection) {
        boolean firsthand;
        boolean bl = firsthand = referrer == null;
        if (firsthand) {
            this.peerOffline.remove((Object)remotePeer.peerId());
            Map<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> removed = this.removeFromMap(remotePeer, this.dataMapUnverified);
            for (Map.Entry<Number320, Map<PeerAddress, Pair<PeerStatistic, Data>>> entry : removed.entrySet()) {
                for (Pair<PeerStatistic, Data> pair : entry.getValue().values()) {
                    this.add(entry.getKey(), ((PeerStatistic)pair.element0()).peerAddress(), this.dataMap, (Data)pair.element1());
                }
            }
        }
        return true;
    }

    public int size() {
        return this.dataMap.size();
    }

    public int sizeUnverified() {
        return this.dataMapUnverified.size();
    }

    public DigestInfo digest(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
        Number160 contentDigest = Number160.ZERO;
        int counter = 0;
        Map<PeerAddress, Pair<PeerStatistic, Data>> trackerData = this.dataMap.get(new Number320(locationKey, domainKey));
        if (trackerData != null) {
            if (contentKey != null) {
                PeerAddress tmpAddress = new PeerAddress(contentKey);
                Pair<PeerStatistic, Data> pair = trackerData.get(tmpAddress);
                if (pair != null) {
                    contentDigest = ((Data)pair.element1()).hash();
                    counter = 1;
                }
            } else {
                for (Map.Entry<PeerAddress, Pair<PeerStatistic, Data>> entry : trackerData.entrySet()) {
                    contentDigest = contentDigest.xor(((Data)entry.getValue().element1()).hash());
                    ++counter;
                }
            }
        }
        return new DigestInfo(Number160.ZERO, contentKey, counter);
    }

    public Map<PeerAddress, Pair<PeerStatistic, Data>> peers(Number320 number320) {
        Map<PeerAddress, Pair<PeerStatistic, Data>> retVal = this.dataMap.get(number320);
        if (retVal == null) {
            return Collections.emptyMap();
        }
        return retVal;
    }

    public TrackerData trackerData(Number320 number320) {
        return new TrackerData(this.peers(number320).values());
    }
}

