/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.tracker.PeerExchangeHandler;
import net.tomp2p.tracker.UtilsTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerExchangeRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PeerExchangeRPC.class);
    public static final int SENT_PEERS_CACHE_SIZE = 1000;
    private final PeerExchangeHandler peerExchange;

    public PeerExchangeRPC(PeerBean peerBean, ConnectionBean connectionBean, PeerExchangeHandler peerExchange) {
        super(peerBean, connectionBean);
        this.register(new int[]{RPC.Commands.PEX.getNr()});
        this.peerExchange = peerExchange;
    }

    public FutureResponse peerExchange(PeerAddress remotePeer, Number320 key, ChannelCreator channelCreator, TrackerData peers, ConnectionConfiguration connectionConfiguration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PEX.getNr(), Message.Type.REQUEST_FF_1);
        LOG.debug("we got stored meshPeers size: {}", (Object)peers);
        if (peers == null || peers.size() == 0) {
            return new FutureResponse(null).response(null);
        }
        peers = UtilsTracker.limit(peers, 35);
        message.key(key.locationKey());
        message.key(key.domainKey());
        LOG.debug("sent ({}) to {} / {}", new Object[]{message.sender().peerId(), remotePeer.peerId(), peers.size()});
        message.trackerData(peers);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), connectionConfiguration);
        if (!connectionConfiguration.isForceTCP()) {
            return requestHandler.fireAndForgetUDP(channelCreator);
        }
        return requestHandler.sendTCP(channelCreator);
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.type() != Message.Type.REQUEST_FF_1 || message.command() != RPC.Commands.PEX.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.key(0);
        Number160 domainKey = message.key(1);
        Number320 key = new Number320(locationKey, domainKey);
        TrackerData tmp = message.trackerData(0);
        this.peerExchange.put(key, tmp, message.sender());
        if (message.isUdp()) {
            responder.responseFireAndForget();
        } else {
            responder.response(this.createResponseMessage(message, Message.Type.OK));
        }
    }
}

