/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.peers.Maintainable;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DigestTracker;
import net.tomp2p.tracker.DistributedTracker;
import net.tomp2p.tracker.PeerExchange;
import net.tomp2p.tracker.PeerExchangeHandler;
import net.tomp2p.tracker.PeerExchangeRPC;
import net.tomp2p.tracker.PeerTracker;
import net.tomp2p.tracker.TrackerRPC;
import net.tomp2p.tracker.TrackerStorage;
import net.tomp2p.tracker.TrackerTriple;
import net.tomp2p.utils.Utils;

public class PeerBuilderTracker {
    private final Peer peer;
    private final Random rnd;
    private PeerExchangeHandler peerExchangeHandler = null;
    private int peerExchangeRefreshSec = -1;
    private ConnectionConfiguration connectionConfiguration = null;
    private int ttl = -1;
    private int replicationFactor = -1;
    private int[] maintenanceInterval = null;
    private Boolean verifyPeersOnTracker;

    public PeerBuilderTracker(Peer peer) {
        this.peer = peer;
        this.rnd = new Random(peer.peerID().longValue());
    }

    public PeerTracker start() {
        TrackerStorage trackerStorage;
        if (this.connectionConfiguration == null) {
            this.connectionConfiguration = new DefaultConnectionConfiguration();
        }
        if (this.peerExchangeRefreshSec == -1) {
            this.peerExchangeRefreshSec = 60;
        }
        if (this.replicationFactor == -1) {
            this.replicationFactor = 20;
        }
        if (this.ttl == -1) {
            this.ttl = 60;
        }
        if (this.maintenanceInterval == null) {
            this.maintenanceInterval = new int[]{2, 4, 8, 16, 32, 64};
        }
        if (this.verifyPeersOnTracker == null) {
            this.verifyPeersOnTracker = Boolean.TRUE;
        }
        if (this.peerExchangeHandler == null) {
            trackerStorage = new TrackerStorage(this.ttl, this.maintenanceInterval, this.replicationFactor, this.peer, this.verifyPeersOnTracker);
            this.peerExchangeHandler = new DefaultPeerExchangeHandler(trackerStorage, this.peer.peerAddress(), this.rnd);
        } else {
            trackerStorage = this.peerExchangeHandler.trackerStorage();
        }
        PeerExchangeRPC peerExchangeRPC = new PeerExchangeRPC(this.peer.peerBean(), this.peer.connectionBean(), this.peerExchangeHandler);
        final PeerExchange peerExchange = new PeerExchange(this.peer, peerExchangeRPC, this.connectionConfiguration);
        trackerStorage.peerExchange(peerExchange);
        ScheduledFuture<?> scheduledFuture = this.peerExchangeRefreshSec > 0 ? this.peer.connectionBean().timer().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TrackerTriple trackerTriple = PeerBuilderTracker.this.peerExchangeHandler.get();
                if (trackerTriple != null) {
                    FutureDone<Void> future = peerExchange.peerExchange(trackerTriple.remotePeer(), trackerTriple.key(), trackerTriple.data());
                    PeerBuilderTracker.this.peer.notifyAutomaticFutures(future);
                }
            }
        }, this.peerExchangeRefreshSec, this.peerExchangeRefreshSec, TimeUnit.SECONDS) : null;
        this.peer.peerBean().addPeerStatusListeners((PeerStatusListener)trackerStorage);
        this.peer.peerBean().peerMap().addPeerMapChangeListener((PeerMapChangeListener)trackerStorage);
        this.peer.peerBean().maintenanceTask().addMaintainable((Maintainable)trackerStorage);
        this.peer.peerBean().digestTracker((DigestTracker)trackerStorage);
        TrackerRPC trackerRPC = new TrackerRPC(this.peer.peerBean(), this.peer.connectionBean(), trackerStorage);
        DistributedTracker distributedTracker = new DistributedTracker(this.peer.peerBean(), this.peer.distributedRouting(), trackerRPC, trackerStorage);
        final PeerTracker peerTracker = new PeerTracker(this.peer, scheduledFuture, trackerRPC, trackerStorage, peerExchange, distributedTracker);
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                peerTracker.shutdown();
                return new FutureDone().done();
            }
        });
        return peerTracker;
    }

    public boolean isVerifyPeersOnTracker() {
        if (this.verifyPeersOnTracker == null) {
            return false;
        }
        return this.verifyPeersOnTracker;
    }

    public PeerBuilderTracker verifyPeersOnTracker() {
        return this.verifyPeersOnTracker(true);
    }

    public PeerBuilderTracker verifyPeersOnTracker(boolean verifyPeersOnTracker) {
        this.verifyPeersOnTracker = verifyPeersOnTracker;
        return this;
    }

    public ConnectionConfiguration connectionConfiguration() {
        return this.connectionConfiguration;
    }

    public PeerBuilderTracker connectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
        return this;
    }

    public PeerExchangeHandler peerExchangeHandler() {
        return this.peerExchangeHandler;
    }

    public PeerBuilderTracker peerExchangeHandler(PeerExchangeHandler peerExchangeHandler) {
        this.peerExchangeHandler = peerExchangeHandler;
        return this;
    }

    public int peerExchangeRefreshSec() {
        return this.peerExchangeRefreshSec;
    }

    public PeerBuilderTracker peerExchangeRefreshSec(int peerExchangeRefreshSec) {
        this.peerExchangeRefreshSec = peerExchangeRefreshSec;
        return this;
    }

    public static class DefaultPeerExchangeHandler
    implements PeerExchangeHandler {
        private final TrackerStorage trackerStorage;
        private final PeerAddress self;
        private final Random rnd;

        public DefaultPeerExchangeHandler(TrackerStorage trackerStorage, PeerAddress self, Random rnd) {
            this.trackerStorage = trackerStorage;
            this.self = self;
            this.rnd = rnd;
        }

        @Override
        public boolean put(Number320 key, TrackerData trackerData, PeerAddress referrer) {
            for (Map.Entry entry : trackerData.peerAddresses().entrySet()) {
                this.trackerStorage.put(key, ((PeerStatatistic)entry.getKey()).peerAddress(), null, (Data)entry.getValue());
            }
            return false;
        }

        @Override
        public TrackerTriple get() {
            Collection<Number320> keys = this.trackerStorage.keys();
            if (keys == null || keys.size() == 0) {
                return null;
            }
            Number320 key = (Number320)Utils.pollRandom(keys, (Random)this.rnd);
            TrackerData trackerData = this.trackerStorage.peers(key);
            if (trackerData == null) {
                return null;
            }
            Set peerStatatistics = trackerData.peerAddresses().keySet();
            if (peerStatatistics == null || peerStatatistics.size() == 0) {
                return null;
            }
            peerStatatistics.remove(new PeerStatatistic(this.self));
            if (peerStatatistics.size() == 0) {
                return null;
            }
            PeerStatatistic peerStatatistic = (PeerStatatistic)Utils.pollRandom(peerStatatistics, (Random)this.rnd);
            return new TrackerTriple().key(key).data(trackerData).remotePeer(peerStatatistic.peerAddress());
        }

        @Override
        public TrackerStorage trackerStorage() {
            return this.trackerStorage;
        }
    }
}

