/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import org.mapdb.Serializer;

public class DataSerializer
implements Serializer<Data>,
Serializable {
    private static final long serialVersionUID = 1428836065493792295L;
    private static final int MAX_SIZE = 10240;
    private final File path;
    private final SignatureFactory signatureFactory;

    public DataSerializer(File path, SignatureFactory signatureFactory) {
        this.path = path;
        this.signatureFactory = signatureFactory;
    }

    public void serialize(DataOutput out, Data value) throws IOException {
        if (value.length() > 10240) {
            out.writeByte(1);
            this.serializeFile(out, value);
        } else {
            out.writeByte(0);
            this.serializeMapDB(out, value);
        }
    }

    private void serializeMapDB(DataOutput out, Data value) throws IOException {
        AlternativeCompositeByteBuf acb = AlternativeCompositeByteBuf.compBuffer();
        value.encodeHeader((ByteBuf)acb, this.signatureFactory);
        this.write(out, acb.nioBuffers());
        acb.skipBytes(acb.writerIndex());
        this.write(out, value.toByteBuffers());
        try {
            value.encodeDone((ByteBuf)acb, this.signatureFactory);
            this.write(out, acb.nioBuffers());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeFile(DataOutput out, Data value) throws IOException, FileNotFoundException {
        Number160 hash = value.hash();
        out.write(hash.toByteArray());
        RandomAccessFile file = null;
        AbstractInterruptibleChannel rwChannel = null;
        try {
            file = new RandomAccessFile(new File(this.path, hash.toString()), "rw");
            rwChannel = file.getChannel();
            AlternativeCompositeByteBuf acb = AlternativeCompositeByteBuf.compBuffer();
            value.encodeHeader((ByteBuf)acb, this.signatureFactory);
            ((FileChannel)rwChannel).write(acb.nioBuffers());
            ((FileChannel)rwChannel).write(value.toByteBuffers());
            try {
                value.encodeDone((ByteBuf)acb, this.signatureFactory);
                ((FileChannel)rwChannel).write(acb.nioBuffers());
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }
        finally {
            if (rwChannel != null) {
                rwChannel.close();
            }
            if (file != null) {
                file.close();
            }
        }
    }

    private void write(DataOutput out, ByteBuffer[] nioBuffers) throws IOException {
        int length = nioBuffers.length;
        for (int i = 0; i < length; ++i) {
            int remaining = nioBuffers[i].remaining();
            if (nioBuffers[i].hasArray()) {
                out.write(nioBuffers[i].array(), nioBuffers[i].arrayOffset(), remaining);
                continue;
            }
            byte[] me = new byte[remaining];
            nioBuffers[i].get(me);
            out.write(me);
        }
    }

    public Data deserialize(DataInput in, int available) throws IOException {
        byte header = in.readByte();
        if (header == 1) {
            return this.deserializeFile(in);
        }
        if (header == 0) {
            return this.deserializeMapDB(in);
        }
        throw new IOException("unexpected header: " + header);
    }

    private Data deserializeMapDB(DataInput in) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        Data data = null;
        while (data == null) {
            buf.writeByte((int)in.readByte());
            data = Data.decodeHeader((ByteBuf)buf, (SignatureFactory)this.signatureFactory);
        }
        int len = data.length();
        byte[] me = new byte[len];
        in.readFully(me);
        buf = Unpooled.wrappedBuffer((byte[])me);
        boolean retVal = data.decodeBuffer(buf);
        if (!retVal) {
            throw new IOException("data could not be read");
        }
        retVal = data.decodeDone(buf, this.signatureFactory);
        if (!retVal) {
            throw new IOException("signature could not be read");
        }
        return data;
    }

    private Data deserializeFile(DataInput in) throws IOException, FileNotFoundException {
        byte[] me = new byte[20];
        in.readFully(me);
        Number160 hash = new Number160(me);
        RandomAccessFile file = new RandomAccessFile(new File(this.path, hash.toString()), "r");
        FileChannel inChannel = file.getChannel();
        MappedByteBuffer buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inChannel.size());
        buffer.load();
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
        Data data = Data.decodeHeader((ByteBuf)buf, (SignatureFactory)this.signatureFactory);
        data.decodeBuffer(buf);
        data.decodeDone(buf, this.signatureFactory);
        file.close();
        return data;
    }

    public int fixedSize() {
        return -1;
    }
}

