/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.File;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.Number640;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DataSerializer;
import net.tomp2p.storage.Storage;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class StorageDisk
implements Storage {
    private final NavigableMap<Number640, Data> dataMap;
    private final Map<Number640, Long> timeoutMap;
    private final ConcurrentNavigableMap<Long, Set<Number640>> timeoutMapRev;
    private final Map<Number320, PublicKey> protectedDomainMap;
    private final Map<Number480, PublicKey> protectedEntryMap;
    private final Map<Number160, Set<Number160>> responsibilityMap;
    private final Map<Number160, Set<Number160>> responsibilityMapRev;
    private final DB db;
    private final int storageCheckIntervalMillis;

    public StorageDisk(DB db, Number160 peerId, File path, SignatureFactory signatureFactory, int storageCheckIntervalMillis) {
        this.db = db;
        DataSerializer dataSerializer = new DataSerializer(path, signatureFactory);
        this.dataMap = db.createTreeMap("dataMap_" + peerId.toString()).valueSerializer((Serializer)dataSerializer).makeOrGet();
        this.timeoutMap = db.createTreeMap("timeoutMap_" + peerId.toString()).makeOrGet();
        this.timeoutMapRev = db.createTreeMap("timeoutMapRev_" + peerId.toString()).makeOrGet();
        this.protectedDomainMap = db.createTreeMap("protectedDomainMap_" + peerId.toString()).makeOrGet();
        this.protectedEntryMap = db.createTreeMap("protectedEntryMap_" + peerId.toString()).makeOrGet();
        this.responsibilityMap = db.createTreeMap("responsibilityMap_" + peerId.toString()).makeOrGet();
        this.responsibilityMapRev = db.createTreeMap("responsibilityMapRev_" + peerId.toString()).makeOrGet();
        this.storageCheckIntervalMillis = storageCheckIntervalMillis;
    }

    public StorageDisk(Number160 peerId, File path, SignatureFactory signatureFactory) {
        this(DBMaker.newFileDB((File)new File(path, "tomp2p")).transactionDisable().closeOnJvmShutdown().make(), peerId, path, signatureFactory, 60000);
    }

    public boolean put(Number640 key, Data value) {
        this.dataMap.put(key, value);
        this.db.commit();
        return true;
    }

    public Data get(Number640 key) {
        return (Data)this.dataMap.get(key);
    }

    public boolean contains(Number640 key) {
        return this.dataMap.containsKey(key);
    }

    public int contains(Number640 from, Number640 to) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        return tmp.size();
    }

    public Data remove(Number640 key, boolean returnData) {
        Data retVal = (Data)this.dataMap.remove(key);
        this.db.commit();
        return retVal;
    }

    public NavigableMap<Number640, Data> remove(Number640 from, Number640 to, boolean returnData) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        for (Map.Entry entry : tmp.entrySet()) {
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        tmp.clear();
        this.db.commit();
        return retVal;
    }

    public NavigableMap<Number640, Data> subMap(Number640 from, Number640 to, int limit, boolean ascending) {
        NavigableMap<Number640, Data> tmp = this.dataMap.subMap(from, true, to, true);
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        if (limit < 0) {
            for (Map.Entry entry : (ascending ? tmp : tmp.descendingMap()).entrySet()) {
                retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
            }
        } else {
            limit = Math.min(limit, tmp.size());
            Iterator iterator = ascending ? tmp.entrySet().iterator() : tmp.descendingMap().entrySet().iterator();
            for (int i = 0; iterator.hasNext() && i < limit; ++i) {
                Map.Entry entry = iterator.next();
                retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
            }
        }
        return retVal;
    }

    public NavigableMap<Number640, Data> map() {
        TreeMap<Number640, Data> retVal = new TreeMap<Number640, Data>();
        for (Map.Entry entry : this.dataMap.entrySet()) {
            retVal.put((Number640)entry.getKey(), (Data)entry.getValue());
        }
        return retVal;
    }

    public void addTimeout(Number640 key, long expiration) {
        Long oldExpiration = this.timeoutMap.put(key, expiration);
        this.putIfAbsent2(expiration, key);
        if (oldExpiration == null) {
            return;
        }
        this.removeRevTimeout(key, oldExpiration);
        this.db.commit();
    }

    private void putIfAbsent2(long expiration, Number640 key) {
        Set timeouts = (Set)this.timeoutMapRev.get(expiration);
        if (timeouts == null) {
            timeouts = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        timeouts.add(key);
        this.timeoutMapRev.put(expiration, timeouts);
    }

    public void removeTimeout(Number640 key) {
        Long expiration = this.timeoutMap.remove(key);
        if (expiration == null) {
            return;
        }
        this.removeRevTimeout(key, expiration);
        this.db.commit();
    }

    private void removeRevTimeout(Number640 key, Long expiration) {
        Set tmp = (Set)this.timeoutMapRev.get(expiration);
        if (tmp != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.timeoutMapRev.remove(expiration);
            } else {
                this.timeoutMapRev.put(expiration, tmp);
            }
        }
    }

    public Collection<Number640> subMapTimeout(long to) {
        SortedMap tmp = this.timeoutMapRev.subMap((Object)0L, (Object)to);
        ArrayList<Number640> toRemove = new ArrayList<Number640>();
        for (Set set : tmp.values()) {
            toRemove.addAll(set);
        }
        return toRemove;
    }

    public Collection<Number160> findPeerIDsForResponsibleContent(Number160 locationKey) {
        return this.responsibilityMap.get(locationKey);
    }

    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        return this.responsibilityMapRev.get(peerID);
    }

    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        boolean isNew1 = this.putIfAbsent0(locationKey, peerId);
        boolean isNew2 = this.putIfAbsent1(peerId, locationKey);
        this.db.commit();
        return isNew1 && isNew2;
    }

    private boolean putIfAbsent0(Number160 locationKey, Number160 peerId) {
        Set<Number160> peerIDs = this.responsibilityMap.get(locationKey);
        if (peerIDs == null) {
            peerIDs = new HashSet<Number160>();
        }
        boolean isNew = peerIDs.add(peerId);
        this.responsibilityMap.put(locationKey, peerIDs);
        return isNew;
    }

    private boolean putIfAbsent1(Number160 peerId, Number160 locationKey) {
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs == null) {
            contentIDs = new HashSet<Number160>();
        }
        boolean isNew = contentIDs.add(locationKey);
        this.responsibilityMapRev.put(locationKey, contentIDs);
        return isNew;
    }

    public void removeResponsibility(Number160 locationKey) {
        Set<Number160> peerIds = this.responsibilityMap.remove(locationKey);
        if (peerIds != null) {
            for (Number160 peerId : peerIds) {
                this.removeRevResponsibility(peerId, locationKey);
            }
            this.db.commit();
        }
    }

    private void removeRevResponsibility(Number160 peerId, Number160 locationKey) {
        Set<Number160> contentIDs = this.responsibilityMapRev.get(peerId);
        if (contentIDs != null) {
            contentIDs.remove(locationKey);
            if (contentIDs.isEmpty()) {
                this.responsibilityMapRev.remove(peerId);
            } else {
                this.responsibilityMapRev.put(peerId, contentIDs);
            }
        }
    }

    public void removeResponsibility(Number160 locationKey, Number160 peerId) {
        Set<Number160> peerIds = this.responsibilityMap.get(locationKey);
        if (peerIds != null && peerIds.remove(peerId)) {
            this.responsibilityMap.put(locationKey, peerIds);
            this.removeRevResponsibility(peerId, locationKey);
            this.db.commit();
        }
    }

    public void close() {
        this.db.close();
    }

    public boolean protectDomain(Number320 key, PublicKey publicKey) {
        this.protectedDomainMap.put(key, publicKey);
        return true;
    }

    public boolean isDomainProtectedByOthers(Number320 key, PublicKey publicKey) {
        PublicKey other = this.protectedDomainMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    public boolean protectEntry(Number480 key, PublicKey publicKey) {
        this.protectedEntryMap.put(key, publicKey);
        return true;
    }

    public boolean isEntryProtectedByOthers(Number480 key, PublicKey publicKey) {
        PublicKey other = this.protectedEntryMap.get(key);
        if (other == null) {
            return false;
        }
        return !other.equals(publicKey);
    }

    public int storageCheckIntervalMillis() {
        return this.storageCheckIntervalMillis;
    }
}

