/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.tomp2p.storage.Data;
import org.mapdb.Serializer;

public class DataSerializer
implements Serializer<Data>,
Serializable {
    private static final long serialVersionUID = 1428836065493792295L;
    private static final int MAX_SIZE = 10240;
    private final File path;

    public DataSerializer(File path) {
        this.path = path;
    }

    public void serialize(DataOutput out, Data value) throws IOException {
        if (value.length() <= 10240) {
            out.writeByte(0);
            ByteBuffer[] buffers = value.toByteBuffers();
            int length = buffers.length;
            for (int i = 0; i < length; ++i) {
                int remaining = buffers[i].remaining();
                if (buffers[i].hasArray()) {
                    out.write(buffers[i].array(), buffers[i].arrayOffset(), remaining);
                    continue;
                }
                byte[] me = new byte[remaining];
                buffers[i].get(me);
                out.write(me);
            }
        }
    }

    public Data deserialize(DataInput in, int available) throws IOException {
        return null;
    }

    public int fixedSize() {
        return -1;
    }
}

