/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.ReplicationListener;
import net.tomp2p.dht.StorageLayer;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.replication.ReplicationFilter;
import net.tomp2p.replication.ResponsibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replication
implements PeerMapChangeListener,
ReplicationListener {
    private static final Logger LOG = LoggerFactory.getLogger(Replication.class);
    private final List<ResponsibilityListener> listeners = new ArrayList<ResponsibilityListener>();
    private final PeerMap peerMap;
    private final PeerAddress selfAddress;
    private final StorageLayer backend;
    private int replicationFactor;
    private boolean nRootReplication;
    private boolean keepData;
    final PeerDHT peer;
    private final Collection<ReplicationFilter> filters;

    public Replication(PeerDHT peer, int replicationFactor, boolean nRoot, boolean keepData, Collection<ReplicationFilter> filters) {
        this.peer = peer;
        this.filters = filters;
        this.backend = peer.storageLayer();
        this.selfAddress = peer.peerAddress();
        this.peerMap = peer.peer().peerBean().peerMap();
        this.replicationFactor = replicationFactor;
        this.nRootReplication = nRoot;
        this.keepData = keepData;
        this.peerMap.addPeerMapChangeListener((PeerMapChangeListener)this);
    }

    public Replication replicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void nRootReplication(boolean nRootReplication) {
        this.nRootReplication = nRootReplication;
    }

    public boolean isNRootReplication() {
        return this.nRootReplication;
    }

    public boolean is0RootReplication() {
        return !this.nRootReplication;
    }

    public void keepData(boolean keepData) {
        this.keepData = keepData;
    }

    public boolean isKeepingData() {
        return this.keepData;
    }

    public boolean isReplication() {
        return this.listeners.size() > 0;
    }

    public void addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.add(responsibilityListener);
    }

    public void removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.remove(responsibilityListener);
    }

    public boolean rejectReplication(PeerAddress address) {
        for (ReplicationFilter filter : this.filters) {
            if (!filter.rejectReplication(address)) continue;
            return true;
        }
        return false;
    }

    private FutureForkJoin<FutureDone<Void>> notifyMeResponsible(Number160 locationKey) {
        FutureDone[] futureDones = new FutureDone[this.listeners.size()];
        int index = 0;
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            futureDones[index++] = responsibilityListener.meResponsible(locationKey);
        }
        FutureForkJoin retVal = new FutureForkJoin(new AtomicReferenceArray<FutureDone>(futureDones));
        this.peer.peer().notifyAutomaticFutures((BaseFuture)retVal);
        return retVal;
    }

    private FutureForkJoin<FutureDone<Void>> notifyMeResponsible(Number160 locationKey, PeerAddress newPeer) {
        FutureDone[] futureDones = new FutureDone[this.listeners.size()];
        int index = 0;
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            futureDones[index++] = responsibilityListener.meResponsible(locationKey, newPeer);
        }
        FutureForkJoin retVal = new FutureForkJoin(new AtomicReferenceArray<FutureDone>(futureDones));
        this.peer.peer().notifyAutomaticFutures((BaseFuture)retVal);
        return retVal;
    }

    private FutureForkJoin<FutureDone<Void>> notifyOtherResponsible(Number160 locationKey, PeerAddress other) {
        FutureDone[] futureDones = new FutureDone[this.listeners.size()];
        int index = 0;
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            futureDones[index++] = responsibilityListener.otherResponsible(locationKey, other);
        }
        FutureForkJoin retVal = new FutureForkJoin(new AtomicReferenceArray<FutureDone>(futureDones));
        this.peer.peer().notifyAutomaticFutures((BaseFuture)retVal);
        return retVal;
    }

    public void dataRemoved(Number160 locationKey) {
        if (!this.isReplication()) {
            return;
        }
    }

    public void dataInserted(final Number160 locationKey) {
        if (!this.isReplication()) {
            return;
        }
        if (!this.nRootReplication) {
            PeerAddress closest = this.closest(locationKey);
            if (closest.peerId().equals((Object)this.selfAddress.peerId())) {
                if (this.backend.updateResponsibilities(locationKey, closest.peerId())) {
                    FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyMeResponsible(locationKey);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                }
            } else if (this.backend.updateResponsibilities(locationKey, closest.peerId())) {
                FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyOtherResponsible(locationKey, closest);
                this.peer.peer().notifyAutomaticFutures(futureForkJoin);
            }
        } else if (this.isInReplicationRange(locationKey, this.selfAddress, this.replicationFactor)) {
            if (this.backend.updateResponsibilities(locationKey, this.selfAddress.peerId())) {
                LOG.debug("I {} am now responsible for key {}.", (Object)this.selfAddress, (Object)locationKey);
                FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyMeResponsible(locationKey);
                this.peer.peer().notifyAutomaticFutures(futureForkJoin);
            }
        } else {
            LOG.debug("I {} am not responsible for key {}.", (Object)this.selfAddress, (Object)locationKey);
            final PeerAddress closest = this.closest(locationKey);
            FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyOtherResponsible(locationKey, closest);
            futureForkJoin.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

                public void operationComplete(BaseFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Replication.this.backend.removeResponsibility(locationKey, Replication.this.keepData);
                    } else {
                        LOG.debug("I {} couldn't notify newly joined peer {} about responsibility for {}. I keep responsibility.", new Object[]{Replication.this.selfAddress, closest, locationKey});
                    }
                }

                public void exceptionCaught(Throwable t) throws Exception {
                    LOG.error("Unexcepted exception ocurred.", t);
                }
            });
            this.peer.peer().notifyAutomaticFutures(futureForkJoin);
        }
    }

    public void peerInserted(final PeerAddress peerAddress, boolean verified) {
        if (!this.isReplication() || !verified) {
            return;
        }
        LOG.debug("The peer {} was inserted in my map. I'm {}", (Object)peerAddress, (Object)this.selfAddress);
        Collection myResponsibleLocations = this.backend.findContentForResponsiblePeerID(this.selfAddress.peerId());
        LOG.debug("I {} have to check replication responsibilities for {}.", (Object)this.selfAddress, (Object)myResponsibleLocations);
        for (final Number160 myResponsibleLocation : myResponsibleLocations) {
            FutureForkJoin<FutureDone<Void>> futureForkJoin;
            PeerAddress closest;
            if (!this.nRootReplication) {
                closest = this.closest(myResponsibleLocation);
                if (!closest.peerId().equals((Object)this.selfAddress.peerId())) {
                    if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                        if (this.backend.updateResponsibilities(myResponsibleLocation, closest.peerId())) {
                            LOG.debug("I {} didn't know that {} is responsible for {}.", new Object[]{this.selfAddress, closest, myResponsibleLocation});
                            futureForkJoin = this.notifyOtherResponsible(myResponsibleLocation, closest);
                            this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                            continue;
                        }
                        LOG.debug("I {} know already that {} is responsible for {}.", new Object[]{this.selfAddress, closest, myResponsibleLocation});
                        continue;
                    }
                    futureForkJoin = this.notifyOtherResponsible(myResponsibleLocation, closest);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                    LOG.debug("I {} am no more in the replica set of {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                    this.backend.removeResponsibility(myResponsibleLocation, this.keepData);
                    continue;
                }
                if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) continue;
                LOG.debug("{} is in the replica set for {}.", (Object)peerAddress, (Object)myResponsibleLocation);
                if (this.backend.updateResponsibilities(myResponsibleLocation, this.selfAddress.peerId())) {
                    LOG.debug("I {} didn't know that I'm responsible for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                    futureForkJoin = this.notifyMeResponsible(myResponsibleLocation);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                    continue;
                }
                LOG.debug("I {} already know that I'm responsible for {}.", (Object)this.selfAddress, (Object)myResponsibleLocation);
                futureForkJoin = this.notifyMeResponsible(myResponsibleLocation, peerAddress);
                this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                continue;
            }
            if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                FutureForkJoin<FutureDone<Void>> futureForkJoin2;
                if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) {
                    LOG.debug("I {} and newly joined peer {} have replication responibility for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    futureForkJoin2 = this.notifyMeResponsible(myResponsibleLocation, peerAddress);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin2);
                    continue;
                }
                LOG.debug("I {} lose and newly joined peer {} gets replication responsibility for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                futureForkJoin2 = this.notifyOtherResponsible(myResponsibleLocation, peerAddress);
                futureForkJoin2.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

                    public void operationComplete(BaseFuture future) throws Exception {
                        if (future.isSuccess()) {
                            Replication.this.backend.removeResponsibility(myResponsibleLocation, Replication.this.keepData);
                        } else {
                            LOG.debug("I {} couldn't notify newly joined peer {} about responsibility for {}. I keep responsibility.", new Object[]{Replication.this.selfAddress, peerAddress, myResponsibleLocation});
                        }
                    }

                    public void exceptionCaught(Throwable t) throws Exception {
                        LOG.error("Unexcepted exception ocurred.", t);
                    }
                });
                this.peer.peer().notifyAutomaticFutures(futureForkJoin2);
                continue;
            }
            if (this.isInReplicationRange(myResponsibleLocation, this.selfAddress, this.replicationFactor)) continue;
            LOG.debug("I {} and newly joined peer {} don't have to replicate {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
            closest = this.closest(myResponsibleLocation);
            futureForkJoin = this.notifyOtherResponsible(myResponsibleLocation, closest);
            futureForkJoin.addListener((BaseFutureListener)new BaseFutureListener<BaseFuture>(){

                public void operationComplete(BaseFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Replication.this.backend.removeResponsibility(myResponsibleLocation, Replication.this.keepData);
                    } else {
                        LOG.debug("I {} couldn't notify newly joined peer {} about responsibility for {}. I keep responsibility.", new Object[]{Replication.this.selfAddress, closest, myResponsibleLocation});
                    }
                }

                public void exceptionCaught(Throwable t) throws Exception {
                    LOG.error("Unexcepted exception ocurred.", t);
                }
            });
            this.peer.peer().notifyAutomaticFutures(futureForkJoin);
        }
    }

    public void peerRemoved(PeerAddress peerAddress, PeerStatistic peerStatatistic) {
        if (!this.isReplication()) {
            return;
        }
        LOG.debug("The peer {} was removed from my map. I'm {}", (Object)peerAddress, (Object)this.selfAddress);
        Collection otherResponsibleLocations = this.backend.findContentForResponsiblePeerID(peerAddress.peerId());
        LOG.debug("I {} know that {} has to replicate {}.", new Object[]{this.selfAddress, peerAddress, otherResponsibleLocations});
        Collection myResponsibleLocations = this.backend.findContentForResponsiblePeerID(this.selfAddress.peerId());
        LOG.debug("I {} have to replicate {}.", (Object)this.selfAddress, (Object)myResponsibleLocations);
        if (!this.nRootReplication) {
            for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
                FutureForkJoin<FutureDone<Void>> futureForkJoin;
                PeerAddress closest = this.closest(otherResponsibleLocation);
                if (closest.peerId().equals((Object)this.selfAddress.peerId())) {
                    if (this.backend.updateResponsibilities(otherResponsibleLocation, closest.peerId())) {
                        LOG.debug("I {} am responsible for {} after leaving of {}.", new Object[]{this.selfAddress, otherResponsibleLocations, peerAddress});
                        futureForkJoin = this.notifyMeResponsible(otherResponsibleLocation);
                        this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                        myResponsibleLocations.remove(otherResponsibleLocation);
                        continue;
                    }
                    LOG.debug("I {} already know that I'm responsible for {} after leaving of {}.", new Object[]{this.selfAddress, otherResponsibleLocations, peerAddress});
                    continue;
                }
                if (!this.backend.updateResponsibilities(otherResponsibleLocation, closest.peerId())) continue;
                LOG.debug("We should check if the closer peer has the content");
                futureForkJoin = this.notifyOtherResponsible(otherResponsibleLocation, closest);
                this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                myResponsibleLocations.remove(otherResponsibleLocation);
            }
            for (Number160 myResponsibleLocation : myResponsibleLocations) {
                if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                    LOG.debug("Leaving {} affects my {} replication responsiblity for {}.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyMeResponsible(myResponsibleLocation);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                    continue;
                }
                LOG.debug("Leaving {} doesn't affect my {} replication responsibility for {}.", new Object[]{peerAddress, this.selfAddress, myResponsibleLocation});
            }
        } else {
            for (Number160 myResponsibleLocation : myResponsibleLocations) {
                if (this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) {
                    LOG.debug("I {} realized that leaving {} had also replication responsibility for {}. The replica set has to get notified about the leaving replica node.", new Object[]{this.selfAddress, peerAddress, myResponsibleLocation});
                    FutureForkJoin<FutureDone<Void>> futureForkJoin = this.notifyMeResponsible(myResponsibleLocation);
                    this.peer.peer().notifyAutomaticFutures(futureForkJoin);
                    continue;
                }
                LOG.debug("Leaving {} doesn't affect my {} replication responsibility for {}.", new Object[]{peerAddress, this.selfAddress, myResponsibleLocation});
            }
        }
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatistic peerStatatistic) {
    }

    private PeerAddress closest(Number160 locationKey) {
        NavigableSet tmp = this.peerMap.closePeers(locationKey, 1);
        tmp.add(new PeerStatistic(this.selfAddress));
        for (PeerStatistic statistic : tmp) {
            if (this.rejectReplication(statistic.peerAddress())) continue;
            return statistic.peerAddress();
        }
        LOG.warn("Not found any peer address that is allowed for replication. Take next best...");
        return ((PeerStatistic)tmp.iterator().next()).peerAddress();
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        if (this.rejectReplication(peerAddress)) {
            LOG.trace("Rejected replication to peer {}", (Object)peerAddress);
            return false;
        }
        NavigableSet tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        PeerStatistic peerAddressStatistic = new PeerStatistic(peerAddress);
        PeerStatistic selfStatistic = new PeerStatistic(this.selfAddress);
        tmp.add(selfStatistic);
        SortedSet<PeerStatistic> tmp2 = tmp.headSet(peerAddressStatistic);
        return tmp2.size() < replicationFactor;
    }
}

