/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.synchronization.Checksum;
import net.tomp2p.synchronization.Instruction;
import net.tomp2p.synchronization.PeerSync;
import net.tomp2p.synchronization.RSync;
import net.tomp2p.synchronization.SyncStat;
import net.tomp2p.synchronization.SyncUtils;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncBuilder
extends DHTBuilder<SyncBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncBuilder.class);
    private static final FutureDone<SyncStat> FUTURE_SHUTDOWN = (FutureDone)new FutureDone().setFailed("sync builder - peer is shutting down");
    static final int DEFAULT_BLOCK_SIZE = 700;
    private final PeerAddress other;
    private final PeerSync peerSync;
    private final int blockSize;
    private DataMap dataMap;
    private Number640 key;
    private Set<Number640> keys;
    private NavigableMap<Number640, Number160> dataMapHash;
    private ArrayList<Instruction> instructions;
    private boolean syncFromOldVersion = false;

    public SyncBuilder(PeerSync peerSync, PeerAddress other) {
        this(peerSync, other, 700);
    }

    public SyncBuilder(PeerSync peerSync, PeerAddress other, int blockSize) {
        super(peerSync.peer(), Number160.ZERO);
        this.self(this);
        this.other = other;
        this.peerSync = peerSync;
        this.blockSize = blockSize;
    }

    public SyncBuilder dataMap(DataMap dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public Number640 key() {
        return this.key;
    }

    public SyncBuilder key(Number640 key) {
        this.key = key;
        return this;
    }

    public Set<Number640> keys() {
        return this.keys;
    }

    public SyncBuilder keys(Set<Number640> keys) {
        this.keys = keys;
        return this;
    }

    public SyncBuilder syncFromOldVersion() {
        this.syncFromOldVersion = true;
        return this;
    }

    public boolean isSyncFromOldVersion() {
        return this.syncFromOldVersion;
    }

    public SyncBuilder syncFromOldVersion(boolean syncFromOldVersion) {
        this.syncFromOldVersion = syncFromOldVersion;
        return this;
    }

    public DataMap dataMap() {
        if (this.dataMap != null) {
            return this.dataMap;
        }
        HashMap<Number640, Data> newDataMap = new HashMap<Number640, Data>();
        if (this.key != null) {
            Data data = this.peer.getPeerBean().storage().get(this.key);
            if (data == null) {
                data = new Data().setFlag2();
            }
            newDataMap.put(this.key, data);
        }
        if (this.keys != null) {
            for (Number640 key : this.keys) {
                Data data = this.peer.getPeerBean().storage().get(key);
                if (data == null) {
                    data = new Data().setFlag2();
                }
                newDataMap.put(key, data);
            }
        }
        if (newDataMap.size() > 0) {
            return new DataMap(newDataMap);
        }
        throw new IllegalArgumentException("Need either dataMap, key, or keys!");
    }

    public NavigableMap<Number640, Number160> dataMapHash() {
        if (this.dataMapHash == null) {
            this.dataMapHash = new TreeMap<Number640, Number160>();
        }
        if (this.dataMap != null) {
            this.dataMapHash.putAll(this.dataMap.convertToHash());
        }
        if (this.key != null) {
            this.dataMapHash.put(this.key, this.peer.getPeerBean().storage().get(this.key).hash());
        }
        if (this.keys != null) {
            for (Number640 key : this.keys) {
                this.dataMapHash.put(key, this.peer.getPeerBean().storage().get(key).hash());
            }
        }
        return this.dataMapHash;
    }

    public ArrayList<Instruction> instructions() {
        return this.instructions;
    }

    public SyncBuilder setDomainKey(Number160 domainKey) {
        throw new IllegalArgumentException("Cannot be set here");
    }

    public FutureDone<SyncStat> start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        final FutureDone futureSync = new FutureDone();
        FutureChannelCreator futureChannelCreator = this.peer.getConnectionBean().reservation().create(0, 2);
        futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(final FutureChannelCreator future2) throws Exception {
                if (!future2.isSuccess()) {
                    futureSync.setFailed((BaseFuture)future2);
                    LOG.error("checkDirect failed {}", (Object)future2.getFailedReason());
                    return;
                }
                final FutureResponse futureResponse = SyncBuilder.this.peerSync.syncRPC().infoMessage(SyncBuilder.this.other, SyncBuilder.this, future2.getChannelCreator());
                futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                    public void operationComplete(FutureResponse future) throws Exception {
                        if (future.isFailed()) {
                            Utils.addReleaseListener((ChannelCreator)future2.getChannelCreator(), (BaseFuture[])new BaseFuture[]{futureResponse});
                            futureSync.setFailed((BaseFuture)future);
                            LOG.error("checkDirect failed {}", (Object)future.getFailedReason());
                            return;
                        }
                        Message responseMessage = future.getResponse();
                        DataMap dataMap = responseMessage.getDataMap(0);
                        if (dataMap == null) {
                            LOG.error("nothing received, something is wrong");
                            futureSync.setFailed("nothing received, something is wrong");
                            return;
                        }
                        HashMap retVal = new HashMap();
                        boolean syncMessageRequired = false;
                        int dataCopy = 0;
                        int dataOrig = 0;
                        for (Map.Entry entry : dataMap.dataMap().entrySet()) {
                            Data data2;
                            Data data = (Data)entry.getValue();
                            if (data.length() == 0) {
                                if (data.isFlag1()) {
                                    LOG.debug("no sync required");
                                    syncMessageRequired = false;
                                    continue;
                                }
                                if (!data.isFlag2()) continue;
                                LOG.debug("copy required for key {}", entry.getKey());
                                syncMessageRequired = true;
                                data2 = SyncBuilder.this.peer.getPeerBean().storage().get((Number640)entry.getKey());
                                dataOrig += data2.length();
                                retVal.put(entry.getKey(), data2);
                                dataCopy += data2.length();
                                continue;
                            }
                            LOG.debug("sync required");
                            syncMessageRequired = true;
                            data2 = SyncBuilder.this.peer.getPeerBean().storage().get((Number640)entry.getKey());
                            dataOrig += data2.length();
                            ByteBuf buffer = data.buffer();
                            Number160 versionKey = SyncUtils.decodeHeader(buffer);
                            Number160 hash = SyncUtils.decodeHeader(buffer);
                            List<Checksum> checksums = SyncUtils.decodeChecksums(buffer);
                            List<Instruction> instructions = RSync.instructions(data2.toBytes(), checksums, SyncBuilder.this.blockSize);
                            AlternativeCompositeByteBuf abuf = AlternativeCompositeByteBuf.compBuffer();
                            dataCopy += SyncUtils.encodeInstructions(instructions, versionKey, hash, abuf);
                            DataBuffer dataBuffer = new DataBuffer((ByteBuf)abuf);
                            Data data1 = new Data(dataBuffer).setFlag1();
                            retVal.put(entry.getKey(), data1);
                        }
                        final SyncStat syncStat = new SyncStat(SyncBuilder.this.peer.getPeerAddress().getPeerId(), SyncBuilder.this.other.getPeerId(), dataCopy, dataOrig);
                        if (syncMessageRequired) {
                            SyncBuilder.this.dataMap(new DataMap(retVal));
                            FutureResponse fr = SyncBuilder.this.peerSync.syncRPC().syncMessage(SyncBuilder.this.other, SyncBuilder.this, future2.getChannelCreator());
                            fr.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                                public void operationComplete(FutureResponse future) throws Exception {
                                    if (future.isFailed()) {
                                        futureSync.setFailed((BaseFuture)future);
                                    } else {
                                        futureSync.setDone((Object)syncStat);
                                    }
                                }
                            });
                            Utils.addReleaseListener((ChannelCreator)future2.getChannelCreator(), (BaseFuture[])new BaseFuture[]{fr, futureResponse});
                        } else {
                            futureSync.setDone((Object)syncStat);
                            Utils.addReleaseListener((ChannelCreator)future2.getChannelCreator(), (BaseFuture[])new BaseFuture[]{futureResponse});
                        }
                    }
                });
            }
        });
        return futureSync;
    }
}

