/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.HashSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.ReplicationFactor;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;

public class AutomaticReplication
implements PeerMapChangeListener,
ReplicationFactor {
    private PeerMap peerMap;
    private HashSet<Number160> removedPeers = new HashSet();
    private double reliability;
    private static final int minReplicationFactor = 2;
    private static final int maxReplicationFactor = -1;
    private static final int observationLength = 10;
    private ArrayList<Integer> observations = null;
    private ArrayList<Double> averages = null;

    public AutomaticReplication(double reliability) {
        this.reliability = reliability;
        this.observations = new ArrayList();
        this.averages = new ArrayList();
        this.averages.add(0.0);
    }

    public void init(Peer peer) {
        this.peerMap = peer.getPeerBean().peerMap();
        this.peerMap.addPeerMapChangeListener((PeerMapChangeListener)this);
    }

    public int getNeighbourPeersSize() {
        return this.peerMap.size();
    }

    public int getRemovedPeersSize() {
        return this.removedPeers.size();
    }

    public void clearRemovedPeers() {
        this.removedPeers.clear();
    }

    public int factor() {
        this.observations.add(this.getRemovedPeersSize());
        this.clearRemovedPeers();
        double average = this.getAverage(this.observations, this.averages);
        this.averages.add(average);
        double predictedValue = this.getPredictedValue(this.observations, average);
        int replicationFactor = this.calculateReplicationFactor((int)Math.round(predictedValue));
        if (this.observations.size() >= 10) {
            this.observations.remove(0);
            this.averages.remove(0);
        }
        return replicationFactor;
    }

    public int calculateReplicationFactor(int predictedValue) {
        boolean ok = true;
        int replicationFactor = 1;
        if (predictedValue >= this.getNeighbourPeersSize()) {
            replicationFactor = this.getNeighbourPeersSize();
            ok = false;
        }
        while (ok) {
            ++replicationFactor;
            double probability = 1.0;
            for (int i = 0; i < replicationFactor; ++i) {
                probability *= (double)(predictedValue - i) / (double)(this.getNeighbourPeersSize() - i);
            }
            if (!(1.0 - probability >= this.reliability) && replicationFactor != -1) continue;
            ok = false;
        }
        return replicationFactor;
    }

    public double getXMean(ArrayList<Integer> x, int k) {
        double sum = 0.0;
        for (int i = k; i < x.size(); ++i) {
            sum += (double)x.get(i).intValue();
        }
        return sum / (double)(x.size() - k);
    }

    public double getYMean(ArrayList<Double> y, int k) {
        double sum = 0.0;
        for (int i = k; i < y.size(); ++i) {
            sum += y.get(i).doubleValue();
        }
        return sum / (double)(y.size() - k);
    }

    public double getSumOfXVariationMultipliedYVariation(ArrayList<Integer> x, ArrayList<Double> y, int k, double xMean, double yMean) {
        double sum = 0.0;
        for (int i = k; i < x.size(); ++i) {
            sum += ((double)x.get(i).intValue() - xMean) * (y.get(i) - yMean);
        }
        return sum;
    }

    public double getSumOfXVariationSquared(ArrayList<Integer> x, int k, double xMean) {
        double sum = 0.0;
        for (int i = k; i < x.size(); ++i) {
            sum += ((double)x.get(i).intValue() - xMean) * ((double)x.get(i).intValue() - xMean);
        }
        return sum;
    }

    public double getSumOfRegressionVariationSquared(ArrayList<Integer> x, int k, double b0, double b1, double yMean) {
        double sum = 0.0;
        for (int i = k; i < x.size(); ++i) {
            double regression = b0 + b1 * (double)x.get(i).intValue();
            sum += (regression - yMean) * (regression - yMean);
        }
        return sum;
    }

    public double getSumOfYVariationSquared(ArrayList<Double> y, int k, double yMean) {
        double sum = 0.0;
        for (int i = k; i < y.size(); ++i) {
            sum += (y.get(i) - yMean) * (y.get(i) - yMean);
        }
        return sum;
    }

    public double getBestSmoothingFactor(ArrayList<Integer> x, ArrayList<Double> y, int initialInterval) {
        double max = 0.0;
        double rSquared = 0.0;
        int interval = initialInterval;
        for (int i = 0; i < x.size() - 2; ++i) {
            double b1;
            double xMean = this.getXMean(x, i);
            double yMean = this.getYMean(y, i);
            double b0 = yMean - (b1 = this.getSumOfXVariationMultipliedYVariation(x, y, i, xMean, yMean) / this.getSumOfXVariationSquared(x, i, xMean)) * xMean;
            rSquared = this.getSumOfRegressionVariationSquared(x, i, b0, b1, yMean) / this.getSumOfYVariationSquared(y, i, yMean);
            if (!(max <= rSquared)) continue;
            max = rSquared;
            interval = x.size() - i;
        }
        return 2.0 / (double)(interval + 1);
    }

    public Double getAverage(ArrayList<Integer> observations, ArrayList<Double> averages) {
        double smoothingFactor = this.getBestSmoothingFactor(observations, averages, observations.size());
        int lastObservation = observations.get(observations.size() - 1);
        double lastAverage = averages.get(averages.size() - 1);
        return ((double)lastObservation - lastAverage) * smoothingFactor + lastAverage;
    }

    public double getStandardDeviation(ArrayList<Integer> range, double currentAverage) {
        double sum = 0.0;
        for (int i = 0; i < range.size(); ++i) {
            sum += ((double)range.get(i).intValue() - currentAverage) * ((double)range.get(i).intValue() - currentAverage);
        }
        if (range.size() == 1) {
            return 0.0;
        }
        return Math.sqrt(sum /= (double)(range.size() - 1));
    }

    public Double getPredictedValue(ArrayList<Integer> observations, double currentAverage) {
        double deviation = this.getStandardDeviation(observations, currentAverage);
        return Math.ceil(currentAverage + deviation);
    }

    public void peerInserted(PeerAddress peerAddress, boolean verified) {
    }

    public void peerRemoved(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
        this.removedPeers.add(peerAddress.getPeerId());
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
    }
}

