/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import java.io.Serializable;
import java.util.Arrays;

public class Checksum
implements Serializable {
    private static final long serialVersionUID = -5313140351556914101L;
    private final int weakChecksum;
    private final byte[] strongChecksum;

    public Checksum(int weakChecksum, byte[] strongChecksum) {
        this.weakChecksum = weakChecksum;
        this.strongChecksum = strongChecksum;
    }

    public int weakChecksum() {
        return this.weakChecksum;
    }

    public byte[] strongChecksum() {
        return this.strongChecksum;
    }

    public int length() {
        return 4 + this.strongChecksum.length;
    }

    public int hashCode() {
        return this.weakChecksum ^ (this.strongChecksum == null ? 0 : Arrays.hashCode(this.strongChecksum));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Checksum)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Checksum c = (Checksum)obj;
        return this.weakChecksum == c.weakChecksum && Arrays.equals(this.strongChecksum, c.strongChecksum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("wcs:");
        sb.append(this.weakChecksum).append(",scs:").append(Arrays.toString(this.strongChecksum));
        return sb.toString();
    }
}

