/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.ArrayList;
import java.util.HashSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.replication.ReplicationFactor;

public class AutoReplication
implements PeerMapChangeListener,
ReplicationFactor {
    private final HashSet<Number160> removedPeers = new HashSet();
    private final ArrayList<Integer> observations = new ArrayList();
    private final ArrayList<Double> emas = new ArrayList();
    private final PeerMap peerMap;
    private double reliability;
    private int minReplicationFactor = 2;
    private int maxReplicationFactor = 100;
    private int observationLength = 10;

    public AutoReplication(Peer peer) {
        this.emas.add(0.0);
        this.peerMap = peer.peerBean().peerMap();
    }

    public AutoReplication start() {
        this.peerMap.addPeerMapChangeListener((PeerMapChangeListener)this);
        return this;
    }

    public AutoReplication shutdown() {
        this.peerMap.removePeerMapChangeListener((PeerMapChangeListener)this);
        return this;
    }

    public void peerInserted(PeerAddress peerAddress, boolean verified) {
    }

    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerRemoved(PeerAddress peerAddress, PeerStatatistic storedPeerAddress) {
        HashSet<Number160> hashSet = this.removedPeers;
        synchronized (hashSet) {
            this.removedPeers.add(peerAddress.peerId());
        }
    }

    public AutoReplication reliability(double reliability) {
        this.reliability = reliability;
        return this;
    }

    public double reliability() {
        return this.reliability;
    }

    public AutoReplication minReplicationFactor(int minReplicationFactor) {
        this.minReplicationFactor = minReplicationFactor;
        return this;
    }

    public int minReplicationFactor() {
        return this.minReplicationFactor;
    }

    public AutoReplication maxReplicationFactor(int maxReplicationFactor) {
        this.maxReplicationFactor = maxReplicationFactor;
        return this;
    }

    public int maxReplicationFactor() {
        return this.maxReplicationFactor;
    }

    public AutoReplication observationLength(int observationLength) {
        this.observationLength = observationLength;
        return this;
    }

    public int observationLength() {
        return this.observationLength;
    }

    public int peerMapSize() {
        return this.peerMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int replicationFactor() {
        int removedPeerSize;
        HashSet<Number160> hashSet = this.removedPeers;
        synchronized (hashSet) {
            removedPeerSize = this.removedPeers.size();
            this.removedPeers.clear();
        }
        this.observations.add(removedPeerSize);
        double average = AutoReplication.ema(this.observations, this.emas);
        this.emas.add(average);
        int predictedValue = AutoReplication.predictedValue(this.observations, average);
        int replicationFactor = AutoReplication.replicationFactor2(predictedValue, this.peerMapSize(), this.reliability, this.minReplicationFactor, this.maxReplicationFactor);
        if (this.observations.size() >= this.observationLength) {
            this.observations.remove(0);
            this.emas.remove(0);
        }
        return replicationFactor;
    }

    public static int replicationFactor(int m, int n, double r, int minReplicationFactor, int maxReplicationFactor) {
        for (int f = minReplicationFactor; f < maxReplicationFactor; ++f) {
            double p = AutoReplication.choose(m, f) / AutoReplication.choose(n, f);
            if (!(1.0 - p >= r)) continue;
            return f;
        }
        return maxReplicationFactor;
    }

    public static double choose(int n, int k) {
        if (k < 0 || k > n) {
            return 0.0;
        }
        if (k > n / 2) {
            k = n - k;
        }
        double answer = 1.0;
        for (int i = 1; i <= k; ++i) {
            answer *= (double)(n + 1 - i);
            answer /= (double)i;
        }
        return answer;
    }

    public static int replicationFactor2(int m, int n, double r, int minReplicationFactor, int maxReplicationFactor) {
        for (int f = minReplicationFactor; f < maxReplicationFactor; ++f) {
            double p = 1.0;
            for (int i = 0; i < f; ++i) {
                p = p * (double)(m - i) / (double)(n - i);
            }
            if (!(1.0 - p >= r)) continue;
            return f;
        }
        return maxReplicationFactor;
    }

    public static double bestSmoothingFactor(ArrayList<Integer> x, ArrayList<Double> y) {
        int size = x.size();
        double max = 0.0;
        int interval = size;
        for (int i = size; i >= 3; --i) {
            double r2 = AutoReplication.linearRegression(x, y, i);
            if (!(r2 >= max)) continue;
            max = r2;
            interval = i;
        }
        return 2.0 / (double)(interval + 1);
    }

    public static double linearRegression(ArrayList<Integer> x, ArrayList<Double> y, int n) {
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            sumx += (double)x.get(i).intValue();
            sumy += y.get(i).doubleValue();
        }
        double xbar = sumx / (double)n;
        double ybar = sumy / (double)n;
        double xxbar = 0.0;
        double yybar = 0.0;
        double xybar = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            xxbar += ((double)x.get(i).intValue() - xbar) * ((double)x.get(i).intValue() - xbar);
            yybar += (y.get(i) - ybar) * (y.get(i) - ybar);
            xybar += ((double)x.get(i).intValue() - xbar) * (y.get(i) - ybar);
        }
        double beta1 = xybar / xxbar;
        double beta0 = ybar - beta1 * xbar;
        double ssr = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            double fit = beta1 * (double)x.get(i).intValue() + beta0;
            ssr += (fit - ybar) * (fit - ybar);
        }
        double r2 = ssr / yybar;
        return r2;
    }

    public static double ema(ArrayList<Integer> observations, ArrayList<Double> emas) {
        double alpha = AutoReplication.bestSmoothingFactor(observations, emas);
        int lastObservation = observations.get(observations.size() - 1);
        double lastEMA = emas.get(emas.size() - 1);
        return lastEMA + alpha * ((double)lastObservation - lastEMA);
    }

    public static double standardDeviation(ArrayList<Integer> range, double average) {
        if (range.size() <= 1) {
            return 0.0;
        }
        double sd = 0.0;
        int size = range.size();
        for (int i = 0; i < size; ++i) {
            sd += Math.pow((double)range.get(i).intValue() - average, 2.0);
        }
        return Math.sqrt(sd /= (double)(size - 1));
    }

    public static int predictedValue(ArrayList<Integer> observations, double currentAverage) {
        double deviation = AutoReplication.standardDeviation(observations, currentAverage);
        return (int)Math.floor(currentAverage + deviation);
    }
}

