/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import java.util.Map;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.dht.ReplicationListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.DataMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.ReplicationSender;
import net.tomp2p.storage.Data;
import net.tomp2p.synchronization.SyncBuilder;
import net.tomp2p.synchronization.SyncRPC;
import net.tomp2p.synchronization.SyncStat;

public class PeerSync
implements ReplicationSender {
    private final SyncRPC syncRPC;
    private final PeerDHT peer;
    private final int blockSize;

    public PeerSync(PeerDHT peer) {
        this(peer, null, 700);
    }

    public PeerSync(PeerDHT peer, int blockSize) {
        this(peer, null, blockSize);
    }

    public PeerSync(PeerDHT peer, ReplicationListener replicationListener, int blockSize) {
        this.peer = peer;
        this.syncRPC = new SyncRPC(peer.peerBean(), peer.peer().connectionBean(), blockSize, peer.storageLayer(), replicationListener);
        this.blockSize = blockSize;
    }

    public PeerDHT peerDHT() {
        return this.peer;
    }

    public SyncRPC syncRPC() {
        return this.syncRPC;
    }

    public SyncBuilder synchronize(PeerAddress other) {
        return new SyncBuilder(this, other, this.blockSize);
    }

    @Override
    public void sendDirect(PeerAddress other, Number160 locationKey, Map<Number640, Data> dataMap) {
        FutureDone<SyncStat> future = this.synchronize(other).dataMap(new DataMap(dataMap)).start();
        this.peer.peer().notifyAutomaticFutures(future);
    }
}

