/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.Checksum;
import net.tomp2p.replication.Instruction;
import net.tomp2p.replication.Synchronization;
import net.tomp2p.replication.SynchronizationDirectBuilder;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizationRPC.class);
    public static final byte INFO_COMMAND = 13;
    public static final byte SYNC_COMMAND = 14;

    public SynchronizationRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.register(new int[]{13, 14});
    }

    public FutureResponse infoMessage(PeerAddress remotePeer, SynchronizationDirectBuilder synchronizationBuilder, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, (byte)13, Message.Type.REQUEST_1);
        if (synchronizationBuilder.isSign()) {
            message.setPublicKeyAndSign(synchronizationBuilder.keyPair());
        }
        KeyMap640 keyMap = new KeyMap640(synchronizationBuilder.dataMapHash());
        message.setKeyMap640(keyMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)synchronizationBuilder);
        LOG.debug("Info sent {}", (Object)message);
        return requestHandler.sendTCP(channelCreator);
    }

    public FutureResponse syncMessage(PeerAddress remotePeer, SynchronizationDirectBuilder synchronizationBuilder, ChannelCreator channelCreator) throws IOException {
        Message message = this.createMessage(remotePeer, (byte)14, Message.Type.REQUEST_1);
        if (synchronizationBuilder.isSign()) {
            message.setPublicKeyAndSign(synchronizationBuilder.keyPair());
        }
        DataMap dataMap = synchronizationBuilder.dataMap();
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)synchronizationBuilder);
        LOG.debug("Sync sent {}", (Object)message);
        return requestHandler.sendTCP(channelCreator);
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getCommand() != 13 && message.getCommand() != 14) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        switch (message.getCommand()) {
            case 13: {
                this.handleInfo(message, responseMessage, responder);
            }
            case 14: {
                this.handleSync(message, responseMessage, responder);
            }
        }
        throw new IllegalArgumentException("Message content is wrong");
    }

    private void handleInfo(Message message, Message responseMessage, Responder responder) {
        LOG.debug("Info received: {} -> {}", (Object)message.getSender().getPeerId(), (Object)message.getRecipient().getPeerId());
        KeyMap640 keysMap = message.getKeyMap640(0);
        HashMap retVal = new HashMap();
        for (Map.Entry entry : keysMap.keysMap().entrySet()) {
            Data data = this.peerBean().storage().get((Number640)entry.getKey());
            if (data != null) {
                if (((Number160)entry.getValue()).equals((Object)data.hash())) {
                    retVal.put(entry.getKey(), new Data(new byte[]{0}));
                    LOG.debug("no sync required");
                    continue;
                }
                ArrayList<Checksum> checksums = Synchronization.getChecksums(data.toBytes(), 5);
                byte[] encoded = Synchronization.encodeChecksumList(checksums);
                retVal.put(entry.getKey(), new Data(encoded));
                LOG.debug("sync required");
                continue;
            }
            retVal.put(entry.getKey(), new Data(new byte[]{1}));
            LOG.debug("copy required");
        }
        responseMessage.setDataMap(new DataMap(retVal));
        responder.response(responseMessage);
    }

    private void handleSync(Message message, Message responseMessage, Responder responder) {
        LOG.debug("Sync received: {} -> {}", (Object)message.getSender().getPeerId(), (Object)message.getRecipient().getPeerId());
        DataMap dataMap = message.getDataMap(0);
        PublicKey publicKey = message.getPublicKey();
        ArrayList retVal = new ArrayList(dataMap.size());
        for (Map.Entry entry : dataMap.dataMap().entrySet()) {
            if (((Data)entry.getValue()).isFlag2()) {
                this.peerBean().storage().remove((Number640)entry.getKey(), publicKey, false);
                continue;
            }
            if (((Data)entry.getValue()).length() <= 0) continue;
            if (((Data)entry.getValue()).isFlag1()) {
                Data data;
                ArrayList<Instruction> instructions = Synchronization.decodeInstructionList(((Data)entry.getValue()).toBytes());
                Number160 hash = Synchronization.decodeHash(((Data)entry.getValue()).toBytes());
                if (hash.equals((Object)(data = this.peerBean().storage().get((Number640)entry.getKey())).hash())) continue;
                byte[] reconstructedValue = Synchronization.getReconstructedValue(data.toBytes(), instructions, 5);
                Enum status = this.peerBean().storage().put((Number640)entry.getKey(), new Data(reconstructedValue), publicKey, false, false);
                if (status == StorageLayer.PutStatus.OK) {
                    retVal.add(entry.getKey());
                }
            } else {
                Enum status = this.peerBean().storage().put((Number640)entry.getKey(), (Data)entry.getValue(), message.getPublicKey(), false, false);
                if (status == StorageLayer.PutStatus.OK) {
                    retVal.add(entry.getKey());
                }
            }
            if (this.peerBean().replicationStorage() == null) continue;
            this.peerBean().replicationStorage().updateAndNotifyResponsibilities(((Number640)entry.getKey()).getLocationKey());
        }
        responseMessage.setKeyCollection(new KeyCollection(retVal));
        responder.response(responseMessage);
    }
}

