/*
 * Copyright 2013 Thomas Bocek, Maxat Pernebayev
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.tomp2p.synchronization;

import java.util.Map;

import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.DataMap;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerInit;
import net.tomp2p.p2p.ReplicationSender;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class ReplicationSync implements ReplicationSender, PeerInit {

	private final int blockSize;
	
	private PeerSync peerSync;
    private Peer peer;
    
    public ReplicationSync() {
    	this.blockSize = SyncBuilder.DEFAULT_BLOCK_SIZE;
    }
    
    public ReplicationSync(final int blockSize) {
    	this.blockSize = blockSize;
    }

    @Override
    public void init(Peer peer) {
        this.peerSync = new PeerSync(peer, blockSize);
        this.peer = peer;
    }

    @Override
    public void sendDirect(PeerAddress other, Number160 locationKey, Map<Number640, Data> dataMap) {
        FutureDone<SyncStat> future = peerSync.synchronize(other)
                .dataMap(new DataMap(dataMap)).start();
        peer.notifyAutomaticFutures(future);
    }
    
    public PeerSync peerSync() {
    	return peerSync;
    }
}
