/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import java.util.Map;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.DataMap;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerInit;
import net.tomp2p.p2p.ReplicationSender;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.synchronization.PeerSync;
import net.tomp2p.synchronization.SyncStat;

public class ReplicationSync
implements ReplicationSender,
PeerInit {
    private final int blockSize;
    private PeerSync peerSync;
    private Peer peer;

    public ReplicationSync() {
        this.blockSize = 700;
    }

    public ReplicationSync(int blockSize) {
        this.blockSize = blockSize;
    }

    public void init(Peer peer) {
        this.peerSync = new PeerSync(peer, this.blockSize);
        this.peer = peer;
    }

    public void sendDirect(PeerAddress other, Number160 locationKey, Map<Number640, Data> dataMap) {
        FutureDone<SyncStat> future = this.peerSync.synchronize(other).dataMap(new DataMap(dataMap)).start();
        this.peer.notifyAutomaticFutures(future);
    }

    public PeerSync peerSync() {
        return this.peerSync;
    }
}

