/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.synchronization.Checksum;
import net.tomp2p.synchronization.Instruction;
import net.tomp2p.utils.Utils;

public final class RSync {
    public static List<Checksum> checksums(byte[] value, int blockSize) {
        int numberOfBlocks = (value.length + blockSize - 1) / blockSize;
        ArrayList<Checksum> checksums = new ArrayList<Checksum>(numberOfBlocks);
        RollingChecksum adler = new RollingChecksum();
        for (int i = 0; i < numberOfBlocks; ++i) {
            int remaining = Math.min(blockSize, value.length - i * blockSize);
            adler.reset().update(value, i * blockSize, remaining);
            int weakChecksum = adler.value();
            byte[] strongChecksum = Utils.makeMD5Hash((byte[])value, (int)(i * blockSize), (int)remaining);
            checksums.add(new Checksum(weakChecksum, strongChecksum));
        }
        return checksums;
    }

    private static int matches(int wcs, byte[] buffer, int offset, int length, List<Checksum> checksums) {
        int checksumSize = checksums.size();
        for (int i = 0; i < checksumSize; ++i) {
            int weakChecksum = checksums.get(i).weakChecksum();
            if (weakChecksum != wcs) continue;
            byte[] md5 = Utils.makeMD5Hash((byte[])buffer, (int)offset, (int)length);
            byte[] strongChecksum = checksums.get(i).strongChecksum();
            if (!Arrays.equals(strongChecksum, md5)) continue;
            return i;
        }
        return -1;
    }

    public static List<Instruction> instructions(byte[] array, List<Checksum> checksums, int blockSize) {
        ArrayList<Instruction> result = new ArrayList<Instruction>(checksums.size());
        RollingChecksum adler = new RollingChecksum();
        int length = array.length;
        int offset = 0;
        int lastRefFound = 0;
        int remaining = Math.min(blockSize, length - offset);
        adler.update(array, offset, remaining);
        while (true) {
            int wcs;
            int reference;
            if ((reference = RSync.matches(wcs = adler.value(), array, offset, remaining, checksums)) != -1) {
                if (offset > lastRefFound) {
                    result.add(new Instruction(new DataBuffer(array, lastRefFound, offset - lastRefFound)));
                }
                result.add(new Instruction(reference));
                lastRefFound = offset += remaining;
                remaining = Math.min(blockSize, length - offset);
                if (remaining == 0) break;
                adler.reset().update(array, offset, remaining);
                continue;
            }
            if (blockSize > length - ++offset) break;
            adler.updateRolling(array);
        }
        if (length > lastRefFound) {
            result.add(new Instruction(new DataBuffer(array, lastRefFound, length - lastRefFound)));
        }
        return result;
    }

    public static DataBuffer reconstruct(byte[] value, List<Instruction> instructions, int blockSize) {
        DataBuffer result = new DataBuffer();
        for (Instruction instruction : instructions) {
            int ref = instruction.reference();
            if (ref != -1) {
                int offset = blockSize * ref;
                int remaining = Math.min(blockSize, value.length - offset);
                result.add(new DataBuffer(value, offset, remaining));
                continue;
            }
            result.add(instruction.literal());
        }
        return result;
    }

    public static class RollingChecksum {
        private int a = 1;
        private int b = 0;
        private int length;
        private int offset;

        public RollingChecksum reset() {
            this.a = 1;
            this.b = 0;
            return this;
        }

        public RollingChecksum update(byte[] array, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                this.a = this.a + (array[i + offset] & 0xFF) & 0xFFFF;
                this.b = this.b + this.a & 0xFFFF;
            }
            this.length = length;
            this.offset = offset;
            return this;
        }

        public int value() {
            return this.b << 16 | this.a;
        }

        public RollingChecksum value(int checksum) {
            this.a = checksum & 0xFFFF;
            this.b = checksum >>> 16;
            return this;
        }

        public RollingChecksum updateRolling(byte[] array) {
            int removeIndex = this.offset;
            int addIndex = this.offset + this.length;
            ++this.offset;
            this.a = this.a - (array[removeIndex] & 0xFF) + (array[addIndex] & 0xFF) & 0xFFFF;
            this.b = this.b - this.length * (array[removeIndex] & 0xFF) + this.a - 1 & 0xFFFF;
            return this;
        }
    }
}

