/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.holep.HolePRPC;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.relay.BaseRelayClient;
import net.tomp2p.relay.BaseRelayServer;
import net.tomp2p.relay.OfflineListener;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayServerConfig;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.buffer.BufferedRelayClient;
import net.tomp2p.relay.buffer.BufferedRelayServer;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayRPC
extends DispatchHandler
implements OfflineListener {
    private static final Logger LOG = LoggerFactory.getLogger(RelayRPC.class);
    private final Peer peer;
    private final Map<RelayType, RelayServerConfig> serverConfigs;
    private final Map<Number160, BaseRelayServer> servers;
    private ConcurrentHashMap<Number160, BaseRelayClient> clients;
    private final RconRPC rconRPC;
    private final HolePRPC holePunchRPC;

    public RelayRPC(Peer peer, RconRPC rconRPC, HolePRPC holePRPC, Map<RelayType, RelayServerConfig> serverConfigs) {
        super(peer.peerBean(), peer.connectionBean());
        this.peer = peer;
        this.serverConfigs = serverConfigs;
        this.servers = new ConcurrentHashMap<Number160, BaseRelayServer>();
        this.clients = new ConcurrentHashMap();
        this.rconRPC = rconRPC;
        this.holePunchRPC = holePRPC;
        this.register(new int[]{RPC.Commands.RELAY.getNr()});
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.debug("Received RPC message {}", (Object)message);
        if (message.type() == Message.Type.REQUEST_1 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleSetup(message, peerConnection, responder);
        } else if (message.type() == Message.Type.REQUEST_2 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handlePiggyBackedMessage(message, responder);
        } else if (message.type() == Message.Type.REQUEST_3 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleMap(message, responder);
        } else if (message.type() == Message.Type.REQUEST_4 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleBuffer(message, responder);
        } else if (message.type() == Message.Type.REQUEST_5 && message.command() == RPC.Commands.RELAY.getNr()) {
            this.handleLateResponse(message, peerConnection, sign, responder);
        } else {
            throw new IllegalArgumentException("Message content is wrong");
        }
    }

    public Peer peer() {
        return this.peer;
    }

    private SignatureFactory signatureFactory() {
        return this.connectionBean().channelServer().channelServerConfiguration().signatureFactory();
    }

    private Dispatcher dispatcher() {
        return this.peer().connectionBean().dispatcher();
    }

    public Set<PeerAddress> unreachablePeers() {
        HashSet<PeerAddress> unreachablePeers = new HashSet<PeerAddress>(this.servers.size());
        for (BaseRelayServer forwarder : this.servers.values()) {
            unreachablePeers.add(forwarder.unreachablePeerAddress());
        }
        return unreachablePeers;
    }

    public void addClient(BaseRelayClient connection) {
        this.clients.put(connection.relayAddress().peerId(), connection);
    }

    public void removeClient(BaseRelayClient connection) {
        this.clients.remove(connection.relayAddress().peerId());
    }

    private void handleSetup(Message message, PeerConnection peerConnection, Responder responder) {
        if (message.intList().isEmpty()) {
            throw new IllegalArgumentException("Setup message should contain an integer value specifying the type");
        }
        RelayType relayType = RelayType.values()[message.intAt(0)];
        if (this.serverConfigs.containsKey((Object)relayType)) {
            BaseRelayServer server = this.serverConfigs.get((Object)relayType).createServer(message, peerConnection, responder, this.peer);
            if (server != null) {
                server.addOfflineListener(this);
                this.registerRelayServer(server);
            }
        } else {
            LOG.warn("Relay client {} requested to serve as relay with type {}. This peer does not support this type.", (Object)message.sender(), (Object)relayType);
            responder.response(this.createResponseMessage(message, Message.Type.DENIED));
        }
    }

    @Override
    public void onUnreachableOffline(PeerAddress unreachablePeer, BaseRelayServer server) {
        this.servers.remove(unreachablePeer);
        this.peerBean().removePeerStatusListener((PeerStatusListener)server);
        this.connectionBean().dispatcher().removeIoHandler(this.peer.peerID(), unreachablePeer.peerId());
        LOG.info("Removed {} from relay because it is offline", (Object)unreachablePeer);
    }

    private void registerRelayServer(BaseRelayServer server) {
        for (RPC.Commands command : RPC.Commands.values()) {
            if (command == RPC.Commands.RCON) {
                this.dispatcher().registerIoHandler(this.peer.peerID(), server.unreachablePeerId(), (DispatchHandler)this.rconRPC, new int[]{command.getNr()});
                continue;
            }
            if (command == RPC.Commands.HOLEP) {
                this.dispatcher().registerIoHandler(this.peer.peerID(), server.unreachablePeerId(), (DispatchHandler)this.holePunchRPC, new int[]{command.getNr()});
                continue;
            }
            if (command == RPC.Commands.RELAY) {
                this.dispatcher().registerIoHandler(this.peer.peerID(), server.unreachablePeerId(), (DispatchHandler)this, new int[]{command.getNr()});
                continue;
            }
            this.dispatcher().registerIoHandler(this.peer.peerID(), server.unreachablePeerId(), (DispatchHandler)server, new int[]{command.getNr()});
        }
        this.peer.peerBean().addPeerStatusListener((PeerStatusListener)server);
        this.servers.put(server.unreachablePeerId(), server);
    }

    private void handlePiggyBackedMessage(Message message, final Responder responderToRelay) throws Exception {
        List peerSocketAddresses = message.peerSocketAddresses();
        InetSocketAddress sender = !peerSocketAddresses.isEmpty() ? PeerSocketAddress.createSocketTCP((PeerSocketAddress)((PeerSocketAddress)peerSocketAddresses.iterator().next())) : new InetSocketAddress(0);
        Buffer requestBuffer = message.buffer(0);
        Message realMessage = RelayUtils.decodeRelayedMessage(requestBuffer.buffer(), message.recipientSocket(), sender, this.signatureFactory());
        realMessage.restoreContentReferences();
        LOG.debug("Received message from relay peer: {}", (Object)realMessage);
        final Message envelope = this.createResponseMessage(message, Message.Type.OK);
        Responder responder = new Responder(){

            public FutureDone<Void> response(Message responseMessage) {
                FutureDone futureDone = new FutureDone();
                LOG.debug("Send reply message to relay peer: {}", (Object)responseMessage);
                try {
                    if (responseMessage.sender().isRelayed() && !responseMessage.sender().peerSocketAddresses().isEmpty()) {
                        responseMessage.peerSocketAddresses(responseMessage.sender().peerSocketAddresses());
                    }
                    envelope.buffer(RelayUtils.encodeMessage(responseMessage, RelayRPC.this.signatureFactory()));
                }
                catch (Exception e) {
                    LOG.error("Cannot piggyback the response", (Throwable)e);
                    futureDone.failed("Cannot piggyback the response");
                    this.failed(Message.Type.EXCEPTION, e.getMessage());
                    return futureDone;
                }
                responderToRelay.response(envelope);
                futureDone.done();
                return futureDone;
            }

            public void failed(Message.Type type, String reason) {
                responderToRelay.failed(type, reason);
            }

            public void responseFireAndForget() {
                responderToRelay.responseFireAndForget();
            }
        };
        DispatchHandler dispatchHandler = this.dispatcher().associatedHandler(realMessage);
        if (dispatchHandler == null) {
            responder.failed(Message.Type.EXCEPTION, "handler not found, probably not relaying peer anymore");
        } else {
            dispatchHandler.handleResponse(realMessage, null, false, responder);
        }
    }

    private void handleMap(Message message, Responder responder) {
        LOG.debug("Handle foreign map update {}", (Object)message);
        BaseRelayServer server = this.servers.get(message.sender().peerId());
        if (server != null) {
            Collection map = message.neighborsSet(0).neighbors();
            Message response = this.createResponseMessage(message, Message.Type.OK);
            server.setPeerMap(RelayUtils.unflatten(map, message.sender()), message, response);
            responder.response(response);
        } else {
            LOG.error("No forwarder for peer {} found. Need to setup relay first");
            responder.response(this.createResponseMessage(message, Message.Type.NOT_FOUND));
        }
    }

    private void handleBuffer(final Message message, final Responder responder) {
        BaseRelayServer server = this.servers.get(message.sender().peerId());
        BaseRelayClient client = this.clients.get(message.sender().peerId());
        if (server != null && server instanceof BufferedRelayServer) {
            LOG.debug("Handle buffer request from unreachable peer {} to server", (Object)message.sender());
            BufferedRelayServer bufferedServer = (BufferedRelayServer)server;
            Message response = this.createResponseMessage(message, Message.Type.OK);
            Buffer bufferedMessages = bufferedServer.collectBufferedMessages();
            if (bufferedMessages != null) {
                response.buffer(bufferedMessages);
            }
            LOG.debug("Responding all buffered messages to Android device {}", (Object)message.sender());
            responder.response(response);
        } else if (client != null && client instanceof BufferedRelayClient) {
            LOG.debug("Handle message with buffer from server {} to unreachable client", (Object)message.sender());
            BufferedRelayClient bufferedClient = (BufferedRelayClient)client;
            FutureDone futureDone = new FutureDone();
            bufferedClient.onReceiveMessageBuffer(message, (FutureDone<Void>)futureDone);
            futureDone.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                public void operationComplete(FutureDone<Void> future) throws Exception {
                    responder.response(RelayRPC.this.createResponseMessage(message, Message.Type.OK));
                }
            });
        } else {
            responder.failed(Message.Type.EXCEPTION, "This message type is intended for buffering forwarders only");
        }
    }

    private void handleLateResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) {
        if (!message.sender().isSlow() || message.bufferList().isEmpty()) {
            throw new IllegalArgumentException("Late response does not come from slow peer or does not contain the buffered message");
        }
        Message realMessage = null;
        try {
            realMessage = RelayUtils.decodeRelayedMessage(message.buffer(0).buffer(), message.recipientSocket(), message.senderSocket(), this.signatureFactory());
        }
        catch (Exception e) {
            LOG.error("Cannot decode the late response", (Throwable)e);
            responder.response(this.createResponseMessage(message, Message.Type.EXCEPTION));
            return;
        }
        LOG.debug("Received late response from slow peer: {}", (Object)realMessage);
        Map pendingRequests = this.dispatcher().getPendingRequests();
        FutureResponse pendingRequest = (FutureResponse)pendingRequests.remove(realMessage.messageId());
        if (pendingRequest != null) {
            pendingRequest.response(realMessage);
            LOG.debug("Successfully answered pending request {} with {}", (Object)pendingRequest.request(), (Object)realMessage);
            responder.response(RelayRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.OK, (PeerAddress)message.recipient()));
        } else if (this.peer().peerAddress().isSlow()) {
            LOG.error("No pending request found for message {}. Ignore it.", (Object)realMessage);
        } else {
            BaseRelayServer forwarder = this.servers.get(realMessage.recipient().peerId());
            if (forwarder == null) {
                LOG.error("Forwarder for the relayed peer not found. Cannot send late response {}", (Object)realMessage);
                responder.response(this.createResponseMessage(message, Message.Type.NOT_FOUND));
            } else {
                LOG.debug("We're just a relay peer. Send wrapped late response to requester wrapper: {} content: {}", (Object)message, (Object)realMessage);
                message.restoreBuffers();
                forwarder.forwardToUnreachable(message);
            }
        }
    }
}

