/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.Futures;
import net.tomp2p.holep.NATType;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATTypeDetection {
    private static final Logger LOG = LoggerFactory.getLogger(NATTypeDetection.class);

    public static FutureDone<NATType> checkNATType(Peer peer, PeerAddress relayPeer) {
        return NATTypeDetection.checkNATType(peer, relayPeer, 5);
    }

    public static FutureDone<NATType> checkNATType(final Peer peer, final PeerAddress relayPeer, final int tolerance) {
        final FutureDone futureDone = new FutureDone();
        final FutureChannelCreator fcc1 = peer.connectionBean().reservation().create(3, 0);
        fcc1.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse1 = peer.pingRPC().pingUDPDiscover(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                    FutureResponse futureResponse2 = peer.pingRPC().pingUDPDiscover(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                    FutureResponse futureResponse3 = peer.pingRPC().pingUDPDiscover(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration());
                    FutureDone fdd = Futures.whenAllSuccess((BaseFuture[])new FutureResponse[]{futureResponse1, futureResponse2, futureResponse3});
                    Utils.addReleaseListener((FutureChannelCreator)fcc1, (BaseFuture)fdd);
                    fdd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<FutureResponse[]>>(){

                        public void operationComplete(FutureDone<FutureResponse[]> future) throws Exception {
                            if (future.isSuccess()) {
                                if (((FutureResponse[])future.object()).length != 3) {
                                    futureDone.failed("expected exactly two futures");
                                    return;
                                }
                                if (!this.checkCompleteMessage(((FutureResponse[])future.object())[0])) {
                                    futureDone.failed("expected filled message0");
                                    return;
                                }
                                if (!this.checkCompleteMessage(((FutureResponse[])future.object())[1])) {
                                    futureDone.failed("expected filled message1");
                                    return;
                                }
                                if (!this.checkCompleteMessage(((FutureResponse[])future.object())[2])) {
                                    futureDone.failed("expected filled message2");
                                    return;
                                }
                                int seenAsPort1 = ((FutureResponse[])future.object())[0].responseMessage().intAt(0);
                                int seenAsPort2 = ((FutureResponse[])future.object())[1].responseMessage().intAt(0);
                                int seenAsPort3 = ((FutureResponse[])future.object())[2].responseMessage().intAt(0);
                                int actualPort1 = ((FutureResponse[])future.object())[0].responseMessage().recipientSocket().getPort();
                                int actualPort2 = ((FutureResponse[])future.object())[1].responseMessage().recipientSocket().getPort();
                                int actualPort3 = ((FutureResponse[])future.object())[2].responseMessage().recipientSocket().getPort();
                                NATType natType = NATTypeDetection.checkNATType(seenAsPort1, seenAsPort2, seenAsPort3, actualPort1, actualPort2, actualPort3, tolerance);
                                futureDone.done((Object)natType);
                            } else {
                                futureDone.failed("expected two successful futures", future);
                            }
                        }

                        private boolean checkCompleteMessage(FutureResponse futureResponse) {
                            Message message = futureResponse.responseMessage();
                            if (message == null) {
                                return false;
                            }
                            if (message.intAt(0) == null) {
                                return false;
                            }
                            if (message.neighborsSet(0) == null) {
                                return false;
                            }
                            if (message.neighborsSet(0).size() < 1) {
                                return false;
                            }
                            return message.recipientSocket() != null;
                        }
                    });
                } else {
                    futureDone.failed("Could not emit NAT type! Channel creation failed", (BaseFuture)future);
                }
            }
        });
        return futureDone;
    }

    private static boolean twoOutOfThreeSame(int i1, int i2, int i3, int k1, int k2, int k3) {
        if (i1 == k1 || i2 == k2) {
            return true;
        }
        if (i1 == k1 || i3 == k3) {
            return true;
        }
        return i2 == k2 || i3 == k3;
    }

    private static boolean sequential(int i1, int i2, int i3, int k1, int k2, int k3, int tolerance) {
        return Math.abs(i1 - k1) < tolerance && Math.abs(i2 - k2) < tolerance && Math.abs(i3 - k3) < tolerance;
    }

    private static NATType checkNATType(int seenAsPort1, int seenAsPort2, int seenAsPort3, int actualPort1, int actualPort2, int actualPort3, int tolerance) {
        if (NATTypeDetection.twoOutOfThreeSame(seenAsPort1, seenAsPort2, seenAsPort3, actualPort1, actualPort2, actualPort3)) {
            LOG.debug("Port preserving NAT detected. UDP hole punching is possible");
            return NATType.PORT_PRESERVING;
        }
        if (NATTypeDetection.sequential(seenAsPort1, seenAsPort2, seenAsPort3, actualPort1, actualPort2, actualPort3, tolerance)) {
            LOG.debug("NAT with sequential port multiplexing detected. UDP hole punching is still possible");
            return NATType.NON_PRESERVING_SEQUENTIAL;
        }
        LOG.debug("Symmetric NAT detected (assumed since all other tests failed)");
        return NATType.NON_PRESERVING_OTHER;
    }
}

