/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep.strategy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.strategy.AbstractHolePStrategy;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;

public class PortPreservingStrategy
extends AbstractHolePStrategy {
    public PortPreservingStrategy(Peer peer, int numberOfHoles, int idleUDPSeconds, Message originalMessage) {
        super(peer, numberOfHoles, idleUDPSeconds, originalMessage);
    }

    @Override
    protected void doPortGuessingInitiatingPeer(Message holePMessage, FutureDone<Message> initMessageFutureDone, List<ChannelFuture> channelFutures) throws Exception {
        ArrayList<Integer> portList = new ArrayList<Integer>(channelFutures.size());
        for (int i = 0; i < channelFutures.size(); ++i) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channelFutures.get(i).channel().localAddress();
            portList.add(inetSocketAddress.getPort());
        }
        holePMessage.intValue(portList.size());
        holePMessage.buffer(this.encodePortList(portList));
        initMessageFutureDone.done((Object)holePMessage);
    }

    @Override
    protected void doPortGuessingTargetPeer(Message replyMessage, FutureDone<Message> replyMessageFuture2) throws Exception {
        List remotePorts = (List)Utils.decodeJavaObject((ByteBuf)this.originalMessage.buffer(0).buffer());
        ArrayList<Integer> replyPorts = new ArrayList<Integer>(this.channelFutures.size() * 2);
        for (int i = 0; i < this.channelFutures.size(); ++i) {
            InetSocketAddress socket = (InetSocketAddress)((ChannelFuture)this.channelFutures.get(i)).channel().localAddress();
            this.portMappings.add(new Pair(remotePorts.get(i), (Object)socket.getPort()));
            replyPorts.add((Integer)remotePorts.get(i));
            replyPorts.add(socket.getPort());
        }
        replyMessage.intValue(replyPorts.size());
        replyMessage.buffer(this.encodePortList(replyPorts));
        replyMessageFuture2.done((Object)replyMessage);
    }

    @Override
    protected FutureDone<List<ChannelFuture>> createChannelFutures(List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> handlersList, FutureDone<Message> mainFutureDone, int numberOfHoles) {
        return super.createChannelFutures(handlersList, mainFutureDone, numberOfHoles);
    }

    @Override
    protected List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> prepareHandlers(boolean initiator, FutureDone<Message> futureDone) {
        return super.prepareHandlers(initiator, futureDone);
    }
}

