/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.Collection;
import java.util.Collections;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayClient;
import net.tomp2p.relay.RelayType;

public abstract class RelayClientConfig {
    private final RelayType type;
    private int peerMapUpdateInterval;
    private Collection<PeerAddress> manualRelays;
    private int failedRelayWaitTime;
    private int maxFail;

    protected RelayClientConfig(RelayType type, int peerMapUpdateInterval, int failedRelayWaitTime, int maxFail) {
        this.type = type;
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        this.failedRelayWaitTime = failedRelayWaitTime;
        this.maxFail = maxFail;
        this.manualRelays = Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.toString());
        sb.append("[Interval:").append(this.peerMapUpdateInterval).append("s").append("]");
        return sb.toString();
    }

    public RelayType type() {
        return this.type;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public RelayClientConfig peerMapUpdateInterval(int peerMapUpdateInterval) {
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManualRelay(PeerAddress manualRelay) {
        Collection<PeerAddress> collection = this.manualRelays;
        synchronized (collection) {
            this.manualRelays.add(manualRelay);
        }
    }

    public RelayClientConfig manualRelays(Collection<PeerAddress> manualRelays) {
        this.manualRelays = manualRelays == null ? Collections.emptySet() : manualRelays;
        return this;
    }

    public Collection<PeerAddress> manualRelays() {
        return this.manualRelays;
    }

    public RelayClientConfig failedRelayWaitTime(int failedRelayWaitTime) {
        if (failedRelayWaitTime < 0) {
            throw new IllegalArgumentException("Negative wait time is not allowed");
        }
        this.failedRelayWaitTime = failedRelayWaitTime;
        return this;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public RelayClientConfig maxFail(int maxFail) {
        if (maxFail < 0) {
            throw new IllegalArgumentException("Negative maximum fail count is not allowed");
        }
        this.maxFail = maxFail;
        return this;
    }

    public int maxFail() {
        return this.maxFail;
    }

    public abstract BaseRelayClient createClient(PeerConnection var1, Peer var2);

    public abstract void prepareSetupMessage(Message var1);

    public abstract void prepareMapUpdateMessage(Message var1);
}

