/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.HashSet;
import java.util.Set;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayListener;

public abstract class BaseRelayClient {
    private final PeerAddress relayAddress;
    protected final Set<RelayListener> listeners;

    public BaseRelayClient(PeerAddress relayAddress) {
        this.relayAddress = relayAddress;
        this.listeners = new HashSet<RelayListener>();
    }

    public PeerAddress relayAddress() {
        return this.relayAddress;
    }

    public abstract FutureResponse sendToRelay(Message var1);

    public abstract FutureDone<Void> shutdown();

    public abstract void onMapUpdateSuccess();

    public abstract void onMapUpdateFailed();

    public final void addCloseListener(RelayListener listener) {
        this.listeners.add(listener);
    }

    protected final void notifyCloseListeners() {
        for (RelayListener relayListener : this.listeners) {
            relayListener.relayFailed(this.relayAddress());
        }
    }
}

