/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import java.util.List;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.NATType;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATTypeDetection {
    private static final int SEQ_PORT_TOLERANCE = 5;
    private NATType natType = null;
    private static final Logger LOG = LoggerFactory.getLogger(NATTypeDetection.class);
    private Peer peer;

    public NATTypeDetection(Peer peer) {
        this.peer = peer;
        this.natType = NATType.UNKNOWN;
    }

    public NATType natType() {
        return this.natType;
    }

    public FutureDone<NATType> checkNATType(PeerAddress relayPeer) {
        FutureDone futureDone = new FutureDone();
        this.pingRelayNATTest((FutureDone<NATType>)futureDone, relayPeer, null, null);
        return futureDone;
    }

    private void pingRelayNATTest(final FutureDone<NATType> fd, final PeerAddress relayPeer, final PeerSocketAddress senderPsa, final PeerSocketAddress recipientPsa) {
        FutureChannelCreator fcc1 = this.peer.connectionBean().reservation().create(1, 0);
        fcc1.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureDone fDone = NATTypeDetection.this.peer.pingRPC().pingNATType(relayPeer, future.channelCreator(), (ConnectionConfiguration)new DefaultConnectionConfiguration(), NATTypeDetection.this.peer);
                    fDone.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<List<PeerSocketAddress>>>(){

                        public void operationComplete(FutureDone<List<PeerSocketAddress>> future) throws Exception {
                            if (future.isSuccess()) {
                                List addresses = (List)future.object();
                                if (senderPsa == null || recipientPsa == null) {
                                    NATTypeDetection.this.pingRelayNATTest((FutureDone<NATType>)fd, relayPeer, (PeerSocketAddress)addresses.get(0), (PeerSocketAddress)addresses.get(1));
                                } else {
                                    NATTypeDetection.this.checkNATType((FutureDone<NATType>)fd, senderPsa, recipientPsa, (PeerSocketAddress)addresses.get(0), (PeerSocketAddress)addresses.get(1));
                                }
                            } else {
                                fd.failed("Could not emit NAT type!");
                            }
                        }
                    });
                } else {
                    fd.failed("Could not emit NAT type!");
                }
            }
        });
    }

    private void checkNATType(FutureDone<NATType> fd, PeerSocketAddress senderPsa, PeerSocketAddress recipientPsa, PeerSocketAddress senderPsa2, PeerSocketAddress recipientPsa2) {
        if (this.peer.peerAddress().peerSocketAddress().inetAddress().equals(recipientPsa.inetAddress())) {
            this.signalNAT("there is no NAT to be traversed!", NATType.NO_NAT, fd);
        } else if (senderPsa.udpPort() == recipientPsa.udpPort() && senderPsa2.udpPort() == recipientPsa2.udpPort()) {
            this.signalNAT("Port preserving NAT detected. UDP hole punching is possible", NATType.PORT_PRESERVING, fd);
        } else if (recipientPsa2.udpPort() - recipientPsa.udpPort() < 5) {
            this.signalNAT("NAT with sequential port multiplexing detected. UDP hole punching is still possible", NATType.NON_PRESERVING_SEQUENTIAL, fd);
        } else {
            this.signalNAT("Symmetric NAT detected (assumed since all other tests failed)", NATType.NON_PRESERVING_OTHER, fd);
        }
    }

    private void signalNAT(String debugMsg, NATType natType, FutureDone<NATType> fd) {
        LOG.warn(debugMsg);
        this.natType = natType;
        fd.done((Object)natType);
    }
}

