/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import net.tomp2p.holep.strategy.HolePStrategy;

public class HolePScheduler
implements Runnable {
    private static final int FIVE_MINUTES = 300;
    private static final int ONE_SECOND_MILLIS = 1000;
    private int numberOfTrials;
    private HolePStrategy holePuncher;

    public HolePScheduler(int numberOfTrials, HolePStrategy holePuncher) {
        if (numberOfTrials > 300) {
            throw new IllegalArgumentException("numberOfTrials can't be higher than 300 (5min)!");
        }
        if (numberOfTrials < 1) {
            throw new IllegalArgumentException("numberOfTrials must be at least 1!");
        }
        if (holePuncher == null) {
            throw new IllegalArgumentException("HolePuncher can't be null!");
        }
        this.numberOfTrials = numberOfTrials;
        this.holePuncher = holePuncher;
    }

    @Override
    public void run() {
        while (this.numberOfTrials != 0) {
            try {
                this.holePuncher.tryConnect();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            --this.numberOfTrials;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

