/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DuplicatesHandler
extends SimpleChannelInboundHandler<Message> {
    private static final int POSITION_ZERO = 0;
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatesHandler.class);
    private final Dispatcher dispatcher;
    private volatile int messageId = 0;
    private volatile boolean first = true;

    public DuplicatesHandler(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        if (msg.isExpectDuplicate()) {
            if (this.first) {
                this.first = false;
                this.messageId = msg.intAt(0);
                this.dispatcher.channelRead(ctx, (Object)msg);
                LOG.debug("message with original messageId = " + this.messageId + " has been received!");
            } else if (this.messageId == msg.intAt(0)) {
                LOG.trace("message with original messageId = " + this.messageId + " has been ignored!");
                ctx.close();
            } else {
                LOG.debug("Message received via hole punching will be forwarded to the Dispatcher!");
                this.dispatcher.channelRead(ctx, (Object)msg);
            }
        } else {
            LOG.debug("Message received via hole punching will be forwarded to the Dispatcher!");
            this.dispatcher.channelRead(ctx, (Object)msg);
        }
    }
}

