/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.io.IOException;
import java.net.InetAddress;
import javax.xml.parsers.ParserConfigurationException;
import net.tomp2p.natpmp.Gateway;
import net.tomp2p.natpmp.MapRequestMessage;
import net.tomp2p.natpmp.NatPmpDevice;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.natpmp.ResultCode;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class NATUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NATUtils.class);
    private GatewayDevice gatewayDevice;
    private int externalPortTCP = -1;
    private int externalPortUDP = -1;
    private NatPmpDevice pmpDevice;
    private final Object shutdownLock = new Object();

    public NATUtils() {
        this.shutdownHookEnabled();
    }

    public boolean mapPMP(int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws NatPmpException {
        InetAddress gateway = Gateway.getIP();
        this.pmpDevice = new NatPmpDevice(gateway);
        MapRequestMessage mapTCP = new MapRequestMessage(true, internalPortTCP, externalPortTCP, Integer.MAX_VALUE, null);
        MapRequestMessage mapUDP = new MapRequestMessage(false, internalPortUDP, externalPortUDP, Integer.MAX_VALUE, null);
        this.pmpDevice.enqueueMessage(mapTCP);
        this.pmpDevice.enqueueMessage(mapUDP);
        this.pmpDevice.waitUntilQueueEmpty();
        return mapTCP.getResultCode() == ResultCode.Success;
    }

    public boolean mapUPNP(String internalHost, int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws IOException, SAXException, ParserConfigurationException {
        if (this.gatewayDevice != null) {
            this.gatewayDevice.deletePortMapping(this.externalPortTCP, "TCP");
            this.gatewayDevice.deletePortMapping(this.externalPortUDP, "UDP");
        }
        GatewayDiscover discover = new GatewayDiscover();
        discover.discover();
        this.gatewayDevice = discover.getValidGateway();
        if (this.gatewayDevice == null) {
            LOGGER.info("no UPNP device found");
            return false;
        }
        this.externalPortTCP = externalPortTCP;
        this.externalPortUDP = externalPortUDP;
        boolean mapTCP = this.gatewayDevice.addPortMapping(externalPortTCP, internalPortTCP, internalHost, "TCP", "TomP2P mapping TCP");
        boolean mapUDP = this.gatewayDevice.addPortMapping(externalPortUDP, internalPortUDP, internalHost, "UDP", "TomP2P mapping UDP");
        if (mapTCP && mapUDP) {
            return true;
        }
        if (!mapTCP) {
            LOGGER.warn("UPNP TCP mapping did failed");
        }
        if (!mapUDP) {
            LOGGER.warn("UPNP UDP mapping did failed");
        }
        return false;
    }

    private void unmapUPNP() throws SAXException, IOException {
        if (this.gatewayDevice != null) {
            try {
                boolean unmapTCP = this.gatewayDevice.deletePortMapping(this.externalPortTCP, "TCP");
                boolean unmapUDP = this.gatewayDevice.deletePortMapping(this.externalPortUDP, "UDP");
                if (!unmapTCP) {
                    LOGGER.warn("UPNP TCP unmapping did failed");
                }
                if (!unmapUDP) {
                    LOGGER.warn("UPNP UDP unmapping did failed");
                }
            }
            finally {
                this.gatewayDevice = null;
            }
        }
    }

    private void shutdownHookEnabled() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                NATUtils.this.shutdown();
            }
        }, "TomP2P:NATUtils:ShutdownHook");
        Runtime.getRuntime().addShutdownHook(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            try {
                this.unmapUPNP();
            }
            catch (Exception e) {
                LOGGER.error("UPNP UDP unmapping did failed", (Throwable)e);
            }
            if (this.pmpDevice != null) {
                this.pmpDevice.shutdown();
                this.pmpDevice = null;
            }
        }
    }
}

