/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.buffer;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayServer;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.buffer.MessageBuffer;
import net.tomp2p.relay.buffer.MessageBufferConfiguration;
import net.tomp2p.relay.buffer.MessageBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BufferedRelayServer
extends BaseRelayServer
implements MessageBufferListener<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedRelayServer.class);
    private final MessageBuffer<Message> buffer;
    private final MessageBufferConfiguration bufferConfig;
    private final List<Message> bufferedMessages;

    protected BufferedRelayServer(Peer peer, PeerAddress unreachablePeer, RelayType relayType, MessageBufferConfiguration bufferConfig) {
        super(peer, unreachablePeer, relayType);
        this.bufferConfig = bufferConfig;
        this.buffer = new MessageBuffer(bufferConfig);
        this.bufferedMessages = Collections.synchronizedList(new ArrayList());
        this.buffer.addListener(this);
    }

    @Override
    public FutureDone<Message> forwardToUnreachable(Message message) {
        FutureDone futureDone = new FutureDone();
        Message response = this.createResponseMessage(message, Message.Type.PARTIALLY_OK);
        response.recipient(message.sender());
        response.sender(this.unreachablePeerAddress());
        try {
            int messageSize = RelayUtils.getMessageSize(message, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
            this.buffer.addMessage(message, messageSize);
        }
        catch (Exception e) {
            LOG.error("Cannot encode the message", (Throwable)e);
            return futureDone.done((Object)this.createResponseMessage(message, Message.Type.EXCEPTION));
        }
        LOG.debug("Added message {} to buffer and returning a partially ok", (Object)message);
        return futureDone.done((Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferFull(List<Message> messages) {
        List<Message> list = this.bufferedMessages;
        synchronized (list) {
            this.bufferedMessages.addAll(messages);
        }
        this.onBufferFull();
    }

    public abstract void onBufferFull();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferFlushed(List<Message> messages) {
        List<Message> list = this.bufferedMessages;
        synchronized (list) {
            this.bufferedMessages.addAll(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer collectBufferedMessages() {
        this.buffer.flushNow();
        Buffer buffer = null;
        List<Message> list = this.bufferedMessages;
        synchronized (list) {
            if (this.bufferedMessages.isEmpty()) {
                LOG.trace("Currently there are no buffered messages");
            } else {
                ByteBuf byteBuffer = RelayUtils.composeMessageBuffer(this.bufferedMessages, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
                LOG.debug("Buffer of {} messages collected", (Object)this.bufferedMessages.size());
                this.bufferedMessages.clear();
                buffer = new Buffer(byteBuffer);
            }
        }
        this.onBufferCollected();
        return buffer;
    }

    protected abstract void onBufferCollected();

    @Override
    protected void peerMapUpdated(Message originalMessage, Message preparedResponse) {
        Buffer bufferedMessages = this.collectBufferedMessages();
        if (bufferedMessages != null) {
            preparedResponse.buffer(bufferedMessages);
        }
    }

    public MessageBufferConfiguration bufferConfiguration() {
        return this.bufferConfig;
    }
}

