/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import net.tomp2p.natpmp.Message;
import net.tomp2p.natpmp.MessageResponseInterface;
import net.tomp2p.natpmp.MessageType;
import net.tomp2p.natpmp.NatPmpException;

public class ExternalAddressRequestMessage
extends Message {
    private byte[] payload = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Inet4Address externalAddress;

    public ExternalAddressRequestMessage(MessageResponseInterface listener) {
        super(MessageType.ExternalAddress, listener);
    }

    public Inet4Address getExternalAddress() throws NatPmpException {
        return this.externalAddress;
    }

    @Override
    void parseResponse(byte[] response) throws NatPmpException {
        try {
            byte[] copy = new byte[4];
            System.arraycopy(response, 8, copy, 0, 4);
            this.externalAddress = (Inet4Address)Inet4Address.getByAddress(copy);
        }
        catch (UnknownHostException ex) {
            throw new NatPmpException("Unable to parse external address.", ex);
        }
    }

    @Override
    byte[] getRequestPayload() {
        return (byte[])this.payload.clone();
    }

    @Override
    byte getOpcode() {
        return 0;
    }
}

