/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.HolePunchInitiator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.HolePunchInitiatorImpl;
import net.tomp2p.holep.HolePunchRPC;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayServerConfig;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.tcp.TCPRelayServerConfig;

public class PeerBuilderNAT {
    private final Peer peer;
    private boolean manualPorts = false;
    private Map<RelayType, RelayServerConfig> relayServerConfigurations;

    public PeerBuilderNAT(Peer peer) {
        this.peer = peer;
        this.relayServerConfigurations = new HashMap<RelayType, RelayServerConfig>();
        this.relayServerConfigurations.put(RelayType.OPENTCP, new TCPRelayServerConfig());
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public PeerBuilderNAT manualPorts() {
        return this.manualPorts(true);
    }

    public PeerBuilderNAT manualPorts(boolean manualPorts) {
        this.manualPorts = manualPorts;
        return this;
    }

    public Map<RelayType, RelayServerConfig> relayServerConfigurations() {
        return this.relayServerConfigurations;
    }

    public PeerBuilderNAT relayServerConfigurations(Map<RelayType, RelayServerConfig> relayServerConfigurations) {
        this.relayServerConfigurations = relayServerConfigurations;
        return this;
    }

    public PeerBuilderNAT addRelayServerConfiguration(RelayType relayType, RelayServerConfig configuration) {
        this.relayServerConfigurations.put(relayType, configuration);
        return this;
    }

    public PeerNAT start() {
        final NATUtils natUtils = new NATUtils();
        RconRPC rconRPC = new RconRPC(this.peer);
        HolePunchRPC holePunchRPC = new HolePunchRPC(this.peer);
        if (this.relayServerConfigurations == null) {
            this.relayServerConfigurations = new HashMap<RelayType, RelayServerConfig>(0);
        } else {
            for (RelayServerConfig config : this.relayServerConfigurations.values()) {
                config.start(this.peer);
            }
        }
        RelayRPC relayRPC = new RelayRPC(this.peer, rconRPC, holePunchRPC, this.relayServerConfigurations);
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                natUtils.shutdown();
                return new FutureDone().done();
            }
        });
        this.peer.peerBean().holePunchInitiator((HolePunchInitiator)new HolePunchInitiatorImpl(this.peer));
        return new PeerNAT(this.peer, natUtils, relayRPC, this.manualPorts);
    }
}

