/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep.testapp;

import java.io.IOException;
import java.net.Inet4Address;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.holep.testapp.HolePStaticStorage;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.PeerBuilderNAT;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.p2p.builder.SendDirectBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.tcp.TCPRelayClientConfig;
import net.tomp2p.rpc.ObjectDataReply;

public class HolePTestApp {
    private static final int port = 4001;
    private static final String PEER_1 = "peer1";
    private static final String PEER_2 = "peer2";
    private static final String PEER_3 = "peer3";
    private static final RelayClientConfig RELAY_CONFIG = new TCPRelayClientConfig();
    private Peer peer;
    private PeerNAT pNAT;
    private PeerAddress masterPeerAddress;
    private PeerAddress natPeerAddress;

    public void startMasterPeer() throws Exception {
        this.peer = new PeerBuilder(Number160.createHash((String)"master")).ports(4001).start();
        this.pNAT = new PeerBuilderNAT(this.peer).start();
        System.err.println("SERVER BOOTSTRAP SUCCESS!");
        System.err.println("IP: " + this.peer.peerAddress().inetAddress());
        System.err.println("ID: " + this.peer.peerID());
        HolePStaticStorage.peerAdresses().put(this.peer.peerID(), this.peer.peerAddress());
        this.peer.objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                PeerAddress reply = null;
                int command = (Integer)request;
                switch (command) {
                    case 0: {
                        HolePStaticStorage.peerAdresses().put(sender.peerId(), sender);
                        System.err.println("NEW PEERADDRESS STORED IN HOLEPSTATICSTORAGE!");
                        System.err.println(sender);
                        break;
                    }
                    case 1: {
                        if (Number160.createHash((String)HolePTestApp.PEER_1).equals((Object)sender.peerId()) || Number160.createHash((String)HolePTestApp.PEER_3).equals((Object)sender.peerId())) {
                            reply = HolePStaticStorage.peerAdresses().get(Number160.createHash((String)HolePTestApp.PEER_2));
                            System.err.println("RETURNED PEERADDRESS OF PEER_2!");
                            System.err.println(sender);
                            break;
                        }
                        reply = HolePStaticStorage.peerAdresses().get(Number160.createHash((String)HolePTestApp.PEER_1));
                        System.err.println("RETURNED PEERADDRESS OF PEER_1!");
                        System.err.println(sender);
                    }
                }
                return reply;
            }
        });
    }

    public void startNormalPeer(String[] args) throws Exception {
        this.peer = new PeerBuilder(Number160.createHash((String)args[1])).ports(4001).start();
        FutureBootstrap fb = this.peer.bootstrap().inetAddress(Inet4Address.getByName(args[0])).ports(4001).start();
        fb.awaitUninterruptibly();
        if (!fb.isSuccess()) {
            System.err.println("ERROR WHILE NORMAL-BOOTSTRAPPING. THE APPLICATION WILL NOW SHUTDOWN!");
            System.exit(1);
        } else {
            System.err.println("NORMAL-BOOTSTRAP SUCCESS!");
        }
    }

    public void startNATPeer(String[] args) throws Exception {
        PeerAddress bootstrapPeerAddress;
        this.peer = new PeerBuilder(Number160.createHash((String)args[1])).ports(4001).start();
        this.masterPeerAddress = bootstrapPeerAddress = new PeerAddress(Number160.createHash((String)"master"), Inet4Address.getByName(args[0]), 4001, 4001);
        PeerAddress upa = this.peer.peerBean().serverPeerAddress();
        upa = upa.changeFirewalledTCP(true).changeFirewalledUDP(true);
        this.peer.peerBean().serverPeerAddress(upa);
        FutureBootstrap futureBootstrap = this.peer.bootstrap().peerAddress(bootstrapPeerAddress).start();
        futureBootstrap.awaitUninterruptibly();
        this.pNAT = new PeerBuilderNAT(this.peer).start();
        FutureRelayNAT frn = this.pNAT.startRelay(RELAY_CONFIG, bootstrapPeerAddress);
        frn.awaitUninterruptibly();
        FutureBootstrap fb = this.peer.bootstrap().peerAddress(bootstrapPeerAddress).start();
        fb.awaitUninterruptibly();
        if (!fb.isSuccess()) {
            System.err.println("ERROR WHILE NAT-BOOTSTRAPPING. THE APPLICATION WILL NOW SHUTDOWN!");
            System.exit(1);
        } else {
            System.err.println("NAT-BOOTSTRAP SUCCESS!");
        }
        FutureDirect fd = this.peer.sendDirect(this.masterPeerAddress).object((Object)new Integer(0)).start();
        fd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDirect>(){

            public void operationComplete(FutureDirect future) throws Exception {
                if (future.isSuccess()) {
                    System.err.println("OWN PEERADDRESS STORED ON SERVER!");
                } else {
                    System.err.println("COULD NOT STORE OWN PEERADDRESS ON SERVER!");
                }
            }
        });
        this.setObjectDataReply2();
    }

    private void setObjectDataReply2() {
        this.peer.objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println("SUCCESS HIT");
                System.out.println("Sender: " + sender.toString());
                System.err.println("NATPEER: " + (String)request);
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println();
                HolePTestApp.this.natPeerAddress = sender;
                return "Hello Successful TomP2P holepunching request";
            }
        });
    }

    private void setObjectDataReply() {
        this.peer.objectDataReply(new ObjectDataReply(){

            public Object reply(PeerAddress sender, Object request) throws Exception {
                System.out.println("Sender: " + sender.toString());
                System.out.println("NATPEER: " + (PeerAddress)request);
                HolePTestApp.this.natPeerAddress = (PeerAddress)request;
                return null;
            }
        });
    }

    public void getOtherPeerAddress() throws ClassNotFoundException, IOException {
        this.setObjectDataReply();
        FutureDirect fDirect = this.peer.sendDirect(this.masterPeerAddress).object((Object)new Integer(1)).start();
        fDirect.awaitUninterruptibly();
        if (fDirect.isSuccess()) {
            System.err.println("Retrieval of PeerAddress of Peer2 successfull!");
            this.natPeerAddress = (PeerAddress)fDirect.object();
        } else {
            System.err.println("FAILFAILFAIL!");
        }
        this.setObjectDataReply2();
    }

    public void sendHolePMessage(int port) throws IOException {
        this.setObjectDataReply();
        if (port == -1) {
            port = 8080;
        }
        FutureDirect fd = this.peer.sendDirect(this.natPeerAddress).object((Object)"Hello World").forceUDP(true).start();
        fd.awaitUninterruptibly();
        if (fd.isSuccess()) {
            System.err.println("WORKS!");
        } else {
            System.err.println("DOES NOT WORK!");
        }
    }

    public void sendDirectMessage() throws IOException {
        this.setObjectDataReply();
        this.peer.peerAddress().changeRelayed(true);
        SendDirectBuilder sdb = this.peer.sendDirect(this.masterPeerAddress.changeRelayed(true)).forceUDP(true).forceTCP(false).object((Object)"Hello World");
        FutureDirect fd = sdb.start();
        fd.awaitUninterruptibly();
        if (!fd.isSuccess()) {
            System.err.println("SENDDIRECT-MESSAGE FAIL!");
        } else {
            System.err.println("SENDDIRECT-MESSAGE SUCCESS!");
        }
    }
}

