/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import java.util.ArrayList;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.HolePuncher;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayServer;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolePunchRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HolePunchRPC.class);
    private final Peer peer;

    public HolePunchRPC(Peer peer) {
        super(peer.peerBean(), peer.connectionBean());
        this.register(new int[]{RPC.Commands.HOLEP.getNr()});
        this.peer = peer;
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.type() == Message.Type.REQUEST_1) {
            LOG.debug("New HolePunch process initiated from peer " + message.sender().peerId() + " to peer " + message.recipient().peerId() + " on ports: " + message.intList().toString());
            this.forwardHolePunchRequest(message, peerConnection, responder);
        } else if (message.type() == Message.Type.REQUEST_2) {
            LOG.debug("HolePunch initiated on peer: " + message.recipient().peerId());
            this.handleHolePunch(message, peerConnection, responder);
        } else {
            throw new IllegalArgumentException("Message Content is wrong!");
        }
    }

    private void handleHolePunch(final Message message, PeerConnection peerConnection, final Responder responder) {
        HolePuncher holePuncher = new HolePuncher(this.peer, message.intList().size(), 30, message);
        FutureDone<Message> replyMessage = holePuncher.replyHolePunch();
        replyMessage.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Message>>(){

            public void operationComplete(FutureDone<Message> future) throws Exception {
                if (future.isSuccess()) {
                    responder.response((Message)future.object());
                } else {
                    HolePunchRPC.this.handleFail(message, responder, "Fail while initiating the hole punching");
                }
            }
        });
    }

    private void forwardHolePunchRequest(final Message message, PeerConnection peerConnection, final Responder responder) {
        BaseRelayServer forwarder = this.extractRelayForwarder(message);
        if (forwarder != null) {
            Message forwardMessage = this.createForwardPortsMessage(message, forwarder.unreachablePeerAddress());
            FutureDone<Message> response = forwarder.forwardToUnreachable(forwardMessage);
            response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Message>>(){

                public void operationComplete(FutureDone<Message> future) throws Exception {
                    if (future.isSuccess()) {
                        Message answerMessage = HolePunchRPC.this.createResponseMessage(message, Message.Type.OK);
                        for (Integer i : ((Message)future.object()).intList()) {
                            answerMessage.intValue(i.intValue());
                        }
                        answerMessage.command(RPC.Commands.HOLEP.getNr());
                        LOG.debug("Returing from relay to requester: {}", (Object)answerMessage);
                        responder.response(answerMessage);
                    } else {
                        responder.failed(Message.Type.DENIED, "Relaying message failed: " + future.failedReason());
                    }
                }
            });
        } else {
            this.handleFail(message, responder, "No RelayForwarder registered for peerId=" + message.recipient().peerId().toString());
        }
    }

    private Message createForwardPortsMessage(Message message, PeerAddress recipient) {
        Message forwardMessage = this.createMessage(recipient, RPC.Commands.HOLEP.getNr(), Message.Type.REQUEST_2);
        forwardMessage.version(message.version());
        forwardMessage.messageId(message.messageId());
        for (Integer port : message.intList()) {
            forwardMessage.intValue(port.intValue());
        }
        NeighborSet ns = new NeighborSet(1, new ArrayList(1));
        ns.add(message.sender());
        forwardMessage.neighborsSet(ns);
        return forwardMessage;
    }

    private BaseRelayServer extractRelayForwarder(Message message) {
        Dispatcher dispatcher = this.peer.connectionBean().dispatcher();
        return (BaseRelayServer)((Object)dispatcher.searchHandler(BaseRelayServer.class, this.peer.peerID(), message.recipient().peerId()));
    }

    private void handleFail(Message message, Responder responder, String failReason) {
        LOG.error(failReason);
        responder.response(this.createResponseMessage(message, Message.Type.EXCEPTION));
    }
}

