/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.tcp;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.relay.BaseRelayForwarderRPC;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCPForwarderRPC
extends BaseRelayForwarderRPC {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCPForwarderRPC.class);
    private final PeerConnection peerConnection;
    private final ConnectionConfiguration config;

    public OpenTCPForwarderRPC(PeerConnection peerConnection, final Peer peer, ConnectionConfiguration config) {
        super(peer, peerConnection.remotePeer(), RelayType.OPENTCP);
        this.config = config;
        this.peerConnection = peerConnection.changeRemotePeer(this.unreachablePeerAddress());
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                peer.peerBean().removePeerStatusListener((PeerStatusListener)OpenTCPForwarderRPC.this);
                peer.connectionBean().dispatcher().removeIoHandler(peer.peerID(), OpenTCPForwarderRPC.this.unreachablePeerId());
            }
        });
        LOG.debug("Created TCP forwarder from peer {} to peer {}", (Object)peer.peerAddress(), (Object)this.unreachablePeerAddress());
    }

    @Override
    public FutureDone<Message> forwardToUnreachable(final Message message) {
        LOG.debug("Sending {} to unreachable peer {}", (Object)message, (Object)this.peerConnection.remotePeer());
        Message envelope = this.createMessage(this.peerConnection.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_2);
        try {
            message.restoreContentReferences();
            envelope.buffer(RelayUtils.encodeMessage(message, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory()));
        }
        catch (Exception e) {
            LOG.error("Cannot encode the message", (Throwable)e);
            return (FutureDone)new FutureDone().failed((Throwable)e);
        }
        envelope.keepAlive(true);
        ArrayList<PeerSocketAddress> peerSocketAddresses = new ArrayList<PeerSocketAddress>(1);
        peerSocketAddresses.add(new PeerSocketAddress(message.sender().inetAddress(), 0, 0));
        envelope.peerSocketAddresses(peerSocketAddresses);
        final FutureDone futureDone = new FutureDone();
        FutureResponse fr = RelayUtils.send(this.peerConnection, this.peerBean(), this.connectionBean(), this.config, envelope);
        fr.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    InetSocketAddress recipientSocket;
                    InetSocketAddress senderSocket = message.recipientSocket();
                    if (senderSocket == null) {
                        senderSocket = OpenTCPForwarderRPC.this.unreachablePeerAddress().createSocketTCP();
                    }
                    if ((recipientSocket = message.senderSocket()) == null) {
                        recipientSocket = message.sender().createSocketTCP();
                    }
                    Buffer buffer = future.responseMessage().buffer(0);
                    Message responseFromUnreachablePeer = RelayUtils.decodeMessage(buffer, recipientSocket, senderSocket, OpenTCPForwarderRPC.this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
                    responseFromUnreachablePeer.restoreContentReferences();
                    futureDone.done((Object)responseFromUnreachablePeer);
                } else {
                    futureDone.failed("Could not forward message over TCP channel");
                }
            }
        });
        return futureDone;
    }

    @Override
    protected void peerMapUpdated() {
    }

    @Override
    protected boolean isAlive() {
        LOG.trace("peerconnection open? {}", (Object)this.peerConnection.isOpen());
        return this.peerConnection.isOpen();
    }
}

