/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.List;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedMessageHandler.class);
    private final Peer peer;
    private final ConnectionConfiguration connectionConfig;

    public BufferedMessageHandler(Peer peer, ConnectionConfiguration connectionConfig) {
        this.peer = peer;
        this.connectionConfig = connectionConfig;
    }

    public void handleBufferResponse(Message bufferResponse, FutureDone<Void> futureDone) {
        Buffer buffer = bufferResponse.buffer(0);
        if (buffer != null) {
            List<Message> bufferedMessages = RelayUtils.decomposeCompositeBuffer(buffer.buffer(), bufferResponse.recipientSocket(), bufferResponse.senderSocket(), this.peer.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
            LOG.debug("Received {} buffered messages", (Object)bufferedMessages.size());
            for (Message bufferedMessage : bufferedMessages) {
                this.processMessage(bufferedMessage);
            }
            futureDone.done();
        } else {
            LOG.warn("Buffer message does not contain any buffered message");
            futureDone.failed("Cannot find any buffer in the message");
        }
    }

    private void processMessage(Message bufferedMessage) {
        DispatchHandler handler = this.peer.connectionBean().dispatcher().associatedHandler(bufferedMessage);
        if (handler == null) {
            LOG.error("Cannot find the associated handler to message {}", (Object)bufferedMessage);
            return;
        }
        try {
            LOG.debug("Handle buffered message {}", (Object)bufferedMessage);
            handler.handleResponse(bufferedMessage, null, false, (Responder)new AndroidDirectResponder(bufferedMessage, handler));
        }
        catch (Exception e) {
            LOG.error("Cannot handle the buffered message {}", (Object)bufferedMessage, (Object)e);
        }
    }

    private class AndroidDirectResponder
    implements Responder {
        private final Message request;
        private final DispatchHandler dispatchHandler;

        public AndroidDirectResponder(Message request, DispatchHandler dispatchHandler) {
            this.request = request;
            this.dispatchHandler = dispatchHandler;
        }

        public void response(Message responseMessage) {
            Message envelope = this.dispatchHandler.createMessage(responseMessage.recipient(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_5);
            try {
                envelope.buffer(RelayUtils.encodeMessage(responseMessage, BufferedMessageHandler.this.peer.connectionBean().channelServer().channelServerConfiguration().signatureFactory()));
            }
            catch (Exception e) {
                LOG.error("Cannot wrap the late response into an envelope", (Throwable)e);
                return;
            }
            LOG.debug("Sending late response {} in an envelope {}", (Object)responseMessage, (Object)envelope);
            FutureResponse futureResponse = RelayUtils.connectAndSend(BufferedMessageHandler.this.peer, envelope, BufferedMessageHandler.this.connectionConfig);
            futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                public void operationComplete(FutureResponse future) throws Exception {
                    if (future.isSuccess()) {
                        LOG.debug("Successfully sent late response to requester");
                    } else {
                        LOG.error("Late response could not be sent to requester. Reason: {}", (Object)future.failedReason());
                    }
                }
            });
        }

        public void failed(Message.Type type, String reason) {
            LOG.warn("Handling of buffered messages resulted in an error: {}", (Object)reason);
            this.response(this.dispatchHandler.createResponseMessage(this.request, type));
        }

        public void responseFireAndForget() {
            this.response(this.dispatchHandler.createResponseMessage(this.request, Message.Type.OK));
        }
    }
}

