/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayConnection;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.BufferedMessageHandler;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRelayConnection
extends BaseRelayConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidRelayConnection.class);
    private static final int MAX_FAIL_COUNT = 5;
    private final DispatchHandler dispatchHandler;
    private final Peer peer;
    private final ConnectionConfiguration config;
    private int reachRelayFailCounter = 0;
    private final BufferedMessageHandler bufferedMessageHandler;
    private final AtomicBoolean shutdown;

    public AndroidRelayConnection(PeerAddress relayAddress, DispatchHandler dispatchHandler, Peer peer, ConnectionConfiguration config) {
        super(relayAddress);
        this.dispatchHandler = dispatchHandler;
        this.peer = peer;
        this.config = config;
        this.bufferedMessageHandler = new BufferedMessageHandler(peer, config);
        this.shutdown = new AtomicBoolean(false);
    }

    @Override
    public FutureResponse sendToRelay(Message message) {
        if (this.shutdown.get()) {
            return (FutureResponse)new FutureResponse(message).failed("Relay connection is already shut down");
        }
        return RelayUtils.connectAndSend(this.peer, message, this.config);
    }

    public FutureDone<Void> sendBufferRequest() {
        if (this.shutdown.get()) {
            return (FutureDone)new FutureDone().failed("Relay connection is already shut down");
        }
        LOG.debug("Sending buffer request to relay {}", (Object)this.relayAddress());
        final FutureDone futureDone = new FutureDone();
        Message message = this.dispatchHandler.createMessage(this.relayAddress(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_4);
        message.keepAlive(false);
        FutureResponse response = this.sendToRelay(message);
        response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse futureResponse) throws Exception {
                if (futureResponse.isSuccess()) {
                    AndroidRelayConnection.this.reachRelayFailCounter = 0;
                    LOG.debug("Successfully got the buffer from relay {}", (Object)AndroidRelayConnection.this.relayAddress());
                    AndroidRelayConnection.this.bufferedMessageHandler.handleBufferResponse(futureResponse.responseMessage(), (FutureDone<Void>)futureDone);
                } else {
                    LOG.error("Cannot get the buffer from relay {}. Reason: {}", (Object)AndroidRelayConnection.this.relayAddress(), (Object)futureResponse.failedReason());
                    futureDone.failed((BaseFuture)futureResponse);
                    AndroidRelayConnection.this.failedToContactRelay();
                }
            }
        });
        return futureDone;
    }

    @Override
    public FutureDone<Void> shutdown() {
        this.shutdown.set(true);
        return new FutureDone().done();
    }

    private void failedToContactRelay() {
        LOG.warn("Failed to contact the relay peer. Increase the counter to detect long-term disconnections");
        ++this.reachRelayFailCounter;
        if (this.reachRelayFailCounter > 5) {
            LOG.error("The relay {} was not reachable for {} send attempts", (Object)this.relayAddress(), (Object)this.reachRelayFailCounter);
            this.notifyCloseListeners();
        }
    }

    @Override
    public void onMapUpdateFailed() {
        this.failedToContactRelay();
    }

    @Override
    public void onMapUpdateSuccess() {
        this.reachRelayFailCounter = 0;
    }
}

