/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Decoder;
import net.tomp2p.message.Encoder;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapConfiguration;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RelayUtils.class);
    private static Charset charset = Charset.forName("UTF-8");
    private static CharsetEncoder encoder = charset.newEncoder();
    private static CharsetDecoder decoder = charset.newDecoder();

    private RelayUtils() {
    }

    public static List<Map<Number160, PeerStatistic>> unflatten(Collection<PeerAddress> map, PeerAddress sender) {
        PeerMapConfiguration peerMapConfiguration = new PeerMapConfiguration(sender.peerId());
        PeerMap peerMap = new PeerMap(peerMapConfiguration);
        for (PeerAddress peerAddress : map) {
            peerMap.peerFound(peerAddress, null, null, null);
        }
        return peerMap.peerMapVerified();
    }

    public static Collection<PeerAddress> flatten(List<Map<Number160, PeerStatistic>> maps) {
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>();
        for (Map<Number160, PeerStatistic> map : maps) {
            for (PeerStatistic peerStatatistic : map.values()) {
                result.add(peerStatatistic.peerAddress());
            }
        }
        return result;
    }

    public static Message decodeRelayedMessage(Buffer buf, InetSocketAddress recipient, InetSocketAddress sender, SignatureFactory signatureFactory) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, IOException {
        Message decodedMessage = RelayUtils.decodeMessage(buf, recipient, sender, signatureFactory);
        boolean isRelay = decodedMessage.sender().isRelayed();
        if (isRelay && !decodedMessage.peerSocketAddresses().isEmpty()) {
            PeerAddress tmpSender = decodedMessage.sender().changePeerSocketAddresses((Collection)decodedMessage.peerSocketAddresses());
            decodedMessage.sender(tmpSender);
        }
        return decodedMessage;
    }

    public static ByteBuf composeMessageBuffer(List<Message> messages, SignatureFactory signatureFactory) {
        ByteBuf buffer = Unpooled.buffer();
        for (Message msg : messages) {
            try {
                msg.restoreContentReferences();
                msg.restoreBuffers();
                Buffer encoded = RelayUtils.encodeMessage(msg, signatureFactory);
                buffer.writeInt(encoded.length());
                buffer.writeBytes(encoded.buffer());
            }
            catch (Exception e) {
                LOG.error("Cannot encode the buffered message. Skip it.", (Throwable)e);
            }
        }
        return buffer;
    }

    public static List<Message> decomposeCompositeBuffer(ByteBuf messageBuffer, InetSocketAddress recipient, InetSocketAddress sender, SignatureFactory signatureFactory) {
        ArrayList<Message> messages = new ArrayList<Message>();
        while (messageBuffer.readableBytes() > 0) {
            int size = messageBuffer.readInt();
            ByteBuf message = messageBuffer.readBytes(size);
            try {
                Message decodedMessage = RelayUtils.decodeRelayedMessage(new Buffer(message), recipient, sender, signatureFactory);
                messages.add(decodedMessage);
            }
            catch (Exception e) {
                LOG.error("Cannot decode buffered message. Skip it.", (Throwable)e);
            }
        }
        return messages;
    }

    public static Buffer encodeMessage(Message message, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        Encoder e = new Encoder(signatureFactory);
        AlternativeCompositeByteBuf buf = AlternativeCompositeByteBuf.compBuffer();
        e.write(buf, message, message.receivedSignature());
        return new Buffer((ByteBuf)buf);
    }

    public static Message decodeMessage(Buffer buf, InetSocketAddress recipient, InetSocketAddress sender, SignatureFactory signatureFactory) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, IOException {
        Decoder d = new Decoder(signatureFactory);
        int readerBefore = buf.buffer().readerIndex();
        d.decodeHeader(buf.buffer(), recipient, sender);
        boolean donePayload = d.decodePayload(buf.buffer());
        d.decodeSignature(buf.buffer(), readerBefore, donePayload);
        return d.message();
    }

    public static int getMessageSize(Message message, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        int size = RelayUtils.encodeMessage(message, signatureFactory).length();
        message.restoreContentReferences();
        message.restoreBuffers();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer encodeString(String content) {
        ByteBuffer byteBuffer;
        if (content == null) {
            return null;
        }
        CharsetEncoder charsetEncoder = encoder;
        synchronized (charsetEncoder) {
            encoder.reset();
            try {
                byteBuffer = encoder.encode(CharBuffer.wrap(content));
            }
            catch (CharacterCodingException e) {
                return null;
            }
            encoder.flush(byteBuffer);
        }
        ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((ByteBuffer)byteBuffer);
        return new Buffer(wrappedBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeString(Buffer buffer) {
        if (buffer == null || buffer.buffer() == null) {
            return null;
        }
        ByteBuffer nioBuffer = buffer.buffer().nioBuffer();
        CharsetDecoder charsetDecoder = decoder;
        synchronized (charsetDecoder) {
            CharBuffer decoded;
            decoder.reset();
            try {
                decoded = decoder.decode(nioBuffer);
            }
            catch (CharacterCodingException e) {
                return null;
            }
            decoder.flush(decoded);
            return decoded.toString();
        }
    }

    private static void send(final PeerConnection peerConnection, PeerBean peerBean, ConnectionBean connectionBean, ConnectionConfiguration config, final FutureResponse futureResponse) {
        final RequestHandler requestHandler = new RequestHandler(futureResponse, peerBean, connectionBean, config);
        FutureChannelCreator fcc = peerConnection.acquire(futureResponse);
        fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    requestHandler.sendTCP(peerConnection.channelCreator(), peerConnection);
                } else {
                    futureResponse.failed((BaseFuture)future);
                }
            }
        });
    }

    public static FutureResponse send(PeerConnection peerConnection, PeerBean peerBean, ConnectionBean connectionBean, ConnectionConfiguration config, Message message) {
        FutureResponse futureResponse = new FutureResponse(message);
        RelayUtils.send(peerConnection, peerBean, connectionBean, config, futureResponse);
        return futureResponse;
    }

    public static FutureResponse connectAndSend(final Peer peer, Message message, final ConnectionConfiguration config) {
        final FutureResponse futureResponse = new FutureResponse(message);
        final FuturePeerConnection fpc = peer.createPeerConnection(message.recipient());
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection futurePeerConnection) throws Exception {
                if (futurePeerConnection.isSuccess()) {
                    PeerConnection peerConnection = (PeerConnection)futurePeerConnection.object();
                    RelayUtils.send(peerConnection, peer.peerBean(), peer.connectionBean(), config, futureResponse);
                } else {
                    futureResponse.failed((BaseFuture)fpc);
                }
            }
        });
        return futureResponse;
    }
}

