/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.HolePunchInitiator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.holep.HolePunchInitiatorImpl;
import net.tomp2p.holep.HolePunchRPC;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.android.MessageBufferConfiguration;
import net.tomp2p.relay.android.gcm.GCMSenderRPC;

public class PeerBuilderNAT {
    private final Peer peer;
    private boolean manualPorts = false;
    private String gcmAuthenticationKey;
    private int gcmSendRetries = 5;
    private MessageBufferConfiguration bufferConfig = new MessageBufferConfiguration();

    public PeerBuilderNAT(Peer peer) {
        this.peer = peer;
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public PeerBuilderNAT manualPorts() {
        return this.manualPorts(true);
    }

    public PeerBuilderNAT manualPorts(boolean manualPorts) {
        this.manualPorts = manualPorts;
        return this;
    }

    public PeerBuilderNAT gcmAuthenticationKey(String gcmAuthenticationKey) {
        this.gcmAuthenticationKey = gcmAuthenticationKey;
        return this;
    }

    public String gcmAuthenticationKey() {
        return this.gcmAuthenticationKey;
    }

    public int gcmSendRetries() {
        return this.gcmSendRetries;
    }

    public PeerBuilderNAT gcmSendRetries(int gcmSendRetries) {
        this.gcmSendRetries = gcmSendRetries;
        return this;
    }

    public MessageBufferConfiguration bufferConfiguration() {
        return this.bufferConfig;
    }

    public PeerBuilderNAT bufferConfiguration(MessageBufferConfiguration bufferConfiguration) {
        this.bufferConfig = bufferConfiguration;
        return this;
    }

    public PeerNAT start() {
        DefaultConnectionConfiguration connectionConfiguration = new DefaultConnectionConfiguration();
        if (this.bufferConfig == null) {
            this.bufferConfig = new MessageBufferConfiguration();
        }
        if (this.gcmSendRetries <= 0) {
            this.gcmSendRetries = 5;
        }
        GCMSenderRPC gcmSenderRPC = null;
        if (this.gcmAuthenticationKey != null && !this.gcmAuthenticationKey.isEmpty()) {
            gcmSenderRPC = new GCMSenderRPC(this.peer, this.gcmAuthenticationKey, this.gcmSendRetries);
        }
        final NATUtils natUtils = new NATUtils();
        RconRPC rconRPC = new RconRPC(this.peer);
        HolePunchRPC holePunchRPC = new HolePunchRPC(this.peer);
        RelayRPC relayRPC = new RelayRPC(this.peer, rconRPC, holePunchRPC, gcmSenderRPC, this.bufferConfig, (ConnectionConfiguration)connectionConfiguration);
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                natUtils.shutdown();
                return new FutureDone().done();
            }
        });
        this.peer.peerBean().holePunchInitiator((HolePunchInitiator)new HolePunchInitiatorImpl(this.peer));
        return new PeerNAT(this.peer, natUtils, relayRPC, this.manualPorts, (ConnectionConfiguration)connectionConfiguration);
    }
}

