/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.android.MessageBufferConfiguration;

public class RelayConfig {
    private final RelayType type;
    private final String registrationId;
    private final MessageBufferConfiguration bufferConfiguration;
    private int peerMapUpdateInterval;
    private Collection<PeerAddress> manualRelays;
    private Collection<PeerAddress> gcmServers;
    private int failedRelayWaitTime;
    private int maxFail;

    public static RelayConfig OpenTCP() {
        return new RelayConfig(RelayType.OPENTCP, 15, null, null, 60, 2);
    }

    public static RelayConfig Android(String registrationId) {
        return RelayConfig.Android(registrationId, null);
    }

    public static RelayConfig Android(String registrationId, MessageBufferConfiguration bufferConfiguration) {
        return new RelayConfig(RelayType.ANDROID, 60, registrationId, bufferConfiguration, 120, 2);
    }

    private RelayConfig(RelayType type, int peerMapUpdateInterval, String registrationId, MessageBufferConfiguration bufferConfiguration, int failedRelayWaitTime, int maxFail) {
        this.type = type;
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        this.registrationId = registrationId;
        this.bufferConfiguration = bufferConfiguration;
        this.failedRelayWaitTime = failedRelayWaitTime;
        this.maxFail = maxFail;
        this.gcmServers = Collections.emptySet();
        this.manualRelays = Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.toString());
        sb.append("[Interval:").append(this.peerMapUpdateInterval).append("s");
        if (this.bufferConfiguration != null) {
            sb.append(", GCM-Buffered");
        }
        sb.append("]");
        return sb.toString();
    }

    public RelayType type() {
        return this.type;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public RelayConfig peerMapUpdateInterval(int peerMapUpdateInterval) {
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManualRelay(PeerAddress manualRelay) {
        Collection<PeerAddress> collection = this.manualRelays;
        synchronized (collection) {
            this.manualRelays.add(manualRelay);
        }
    }

    public RelayConfig manualRelays(Collection<PeerAddress> manualRelays) {
        this.manualRelays = manualRelays == null ? Collections.emptySet() : manualRelays;
        return this;
    }

    public Collection<PeerAddress> manualRelays() {
        return this.manualRelays;
    }

    public RelayConfig failedRelayWaitTime(int failedRelayWaitTime) {
        if (failedRelayWaitTime < 0) {
            throw new IllegalArgumentException("Negative wait time is not allowed");
        }
        this.failedRelayWaitTime = failedRelayWaitTime;
        return this;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public RelayConfig maxFail(int maxFail) {
        if (maxFail < 0) {
            throw new IllegalArgumentException("Negative maximum fail count is not allowed");
        }
        this.maxFail = maxFail;
        return this;
    }

    public int maxFail() {
        return this.maxFail;
    }

    public String registrationId() {
        return this.registrationId;
    }

    public MessageBufferConfiguration bufferConfiguration() {
        return this.bufferConfiguration;
    }

    public Collection<PeerAddress> gcmServers() {
        return this.gcmServers;
    }

    public RelayConfig gcmServers(Set<PeerAddress> gcmServers) {
        this.gcmServers = gcmServers == null ? Collections.emptySet() : gcmServers;
        return this;
    }
}

