/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayForwarderRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RelayForwarderRPC.class);
    private final PeerConnection peerConnection;
    private List<Map<Number160, PeerStatatistic>> peerMap = null;
    private final RelayRPC relayRPC;

    public RelayForwarderRPC(PeerConnection peerConnection, Peer peer, RelayRPC relayRPC) {
        super(peer.getPeerBean(), peer.getConnectionBean());
        PeerAddress unreachablePeer = peerConnection.remotePeer();
        this.peerConnection = peerConnection;
        this.relayRPC = relayRPC;
        LOG.debug("created forwarder from peer {} to peer {}", (Object)peer.getPeerAddress(), (Object)unreachablePeer);
    }

    public void register(Peer peer) {
        for (RPC.Commands command : RPC.Commands.values()) {
            if (command == RPC.Commands.RELAY) continue;
            peer.getConnectionBean().dispatcher().registerIoHandler(this.peerConnection.remotePeer().getPeerId(), (DispatchHandler)this, new int[]{command.getNr()});
        }
    }

    public static void register(PeerConnection peerConnection, Peer peer, RelayRPC relayRPC) {
        RelayForwarderRPC relayForwarderRPC = new RelayForwarderRPC(peerConnection, peer, relayRPC);
        relayForwarderRPC.register(peer);
    }

    public static void unregister(Peer peer, Number160 unreachablePeer) {
        peer.getConnectionBean().dispatcher().removeIoHandler(unreachablePeer);
    }

    public static RelayForwarderRPC find(Peer peer, Number160 peerId) {
        return (RelayForwarderRPC)peer.getConnectionBean().dispatcher().searchHandler(peerId, (int)RPC.Commands.NEIGHBOR.getNr());
    }

    public void handleResponse(Message message, PeerConnection peerConnectionUnused, boolean sign, Responder responder) throws Exception {
        PeerAddress sender = this.peerBean().serverPeerAddress().changePeerId(this.peerConnection.remotePeer().getPeerId());
        if (message.getCommand() == RPC.Commands.PING.getNr()) {
            LOG.debug("Received message {} to handle ping for unreachable peer {}", (Object)message, (Object)this.peerConnection.remotePeer());
            this.handlePing(message, responder, sender);
        } else if (message.getCommand() == RPC.Commands.NEIGHBOR.getNr()) {
            LOG.debug("Received message {} to handle neighbor request for unreachable peer {}", (Object)message, (Object)this.peerConnection.remotePeer());
            this.handleNeigbhor(message, responder, sender);
        } else {
            LOG.debug("Received message {} to forward to unreachable peer {}", (Object)message, (Object)this.peerConnection.remotePeer());
            this.handleRelay(message, responder, sender);
        }
    }

    private void handleRelay(final Message message, final Responder responder, final PeerAddress sender) throws InvalidKeyException, SignatureException, IOException {
        message.restoreContentReferences();
        Buffer buf = RelayUtils.encodeMessage(message);
        FutureResponse fr = this.relayRPC.forwardMessage(this.peerConnection, buf);
        fr.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    Buffer buffer = future.getResponse().getBuffer(0);
                    Message responseFromUnreachablePeer = RelayUtils.decodeMessage(buffer, message.recipientSocket(), message.senderSocket());
                    responseFromUnreachablePeer.restoreContentReferences();
                    responseFromUnreachablePeer.setSender(sender);
                    responseFromUnreachablePeer.setRecipient(message.getSender());
                    LOG.debug("response from unreachable peer: {}", (Object)responseFromUnreachablePeer);
                    responder.response(responseFromUnreachablePeer);
                } else {
                    responder.failed(Message.Type.USER1, "Relaying message failed: " + future.getFailedReason());
                }
            }
        });
    }

    private void handlePing(Message message, Responder responder, PeerAddress sender) {
        Message response = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)(this.peerConnection.isOpen() ? Message.Type.OK : Message.Type.EXCEPTION), (PeerAddress)sender);
        responder.response(response);
    }

    public void handleNeigbhor(Message message, Responder responder, PeerAddress sender) throws IOException {
        if (message.getKeyList().size() < 2) {
            throw new IllegalArgumentException("We need the location and domain key at least");
        }
        if (message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 && message.getType() != Message.Type.REQUEST_3 && message.getType() != Message.Type.REQUEST_4 && message.getCommand() == RPC.Commands.NEIGHBOR.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.getKey(0);
        SortedSet<PeerAddress> neighbors = this.getNeighbors(locationKey, 30);
        if (neighbors == null) {
            Message response = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.NOT_FOUND, (PeerAddress)sender);
            response.setNeighborsSet(new NeighborSet(-1));
            responder.response(response);
            return;
        }
        Message responseMessage = RelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.OK, (PeerAddress)sender);
        LOG.debug("found the following neighbors {}", neighbors);
        NeighborSet neighborSet = new NeighborSet(1000, neighbors);
        responseMessage.setNeighborsSet(neighborSet);
        responder.response(responseMessage);
    }

    private SortedSet<PeerAddress> getNeighbors(Number160 id, int atLeast) {
        LOG.trace("Answering routing request on behalf of unreachable peer {}, neighbors of {}", (Object)this.peerConnection.remotePeer(), (Object)id);
        if (this.peerMap == null) {
            return null;
        }
        return PeerMap.closePeers((Number160)this.peerConnection.remotePeer().getPeerId(), (Number160)id, (int)30, this.peerMap);
    }

    public Collection<PeerAddress> getAll() {
        ArrayList<PeerStatatistic> result1 = new ArrayList<PeerStatatistic>();
        for (Map<Number160, PeerStatatistic> map : this.peerMap) {
            result1.addAll(map.values());
        }
        ArrayList<PeerAddress> result2 = new ArrayList<PeerAddress>();
        for (PeerStatatistic peerStatatistic : result1) {
            result2.add(peerStatatistic.getPeerAddress());
        }
        return result2;
    }

    public void setMap(List<Map<Number160, PeerStatatistic>> peerMap) {
        this.peerMap = peerMap;
    }
}

