/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayManager;
import net.tomp2p.relay.RelayRPC;

class PeerMapUpdateTask
extends TimerTask {
    private RelayRPC relayRPC;
    private BootstrapBuilder bootstrapBuilder;
    private Set<PeerAddress> relayAddresses;

    public PeerMapUpdateTask(RelayRPC relayRPC, BootstrapBuilder bootstrapBuilder, Set<PeerAddress> relayAddresses) {
        this.relayRPC = relayRPC;
        this.bootstrapBuilder = bootstrapBuilder;
        this.relayAddresses = relayAddresses;
    }

    @Override
    public void run() {
        if (this.relayRPC.peer().isShutdown() || !this.relayRPC.peer().getPeerAddress().isRelayed()) {
            this.cancel();
            return;
        }
        FutureBootstrap fb = this.bootstrapBuilder.start();
        fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    List peerMapVerified = PeerMapUpdateTask.this.relayRPC.peer().getPeerBean().peerMap().peerMapVerified();
                    for (final PeerAddress relay : PeerMapUpdateTask.this.relayAddresses) {
                        FutureChannelCreator fcc = PeerMapUpdateTask.this.relayRPC.peer().getConnectionBean().reservation().create(0, 1);
                        FutureResponse fr = PeerMapUpdateTask.this.relayRPC.sendPeerMap(relay, peerMapVerified, fcc);
                        fr.addListener((BaseFutureListener)new BaseFutureAdapter<BaseFuture>(){

                            public void operationComplete(BaseFuture future) throws Exception {
                                if (future.isFailed()) {
                                    RelayManager.LOG.warn("failed to update peer map on relay peer {}: {}", (Object)relay, (Object)future.getFailedReason());
                                } else {
                                    RelayManager.LOG.trace("Updated peer map on relay {}", (Object)relay);
                                }
                            }
                        });
                    }
                }
            }
        });
    }
}

