/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayForwarderRPC;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.MessageBuffer;
import net.tomp2p.relay.android.MessageBufferConfiguration;
import net.tomp2p.relay.android.MessageBufferListener;
import net.tomp2p.relay.android.gcm.FutureGCM;
import net.tomp2p.relay.android.gcm.IGCMSender;
import net.tomp2p.relay.android.gcm.RemoteGCMSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidForwarderRPC
extends BaseRelayForwarderRPC
implements MessageBufferListener<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidForwarderRPC.class);
    private final String registrationId;
    private final IGCMSender sender;
    private final int mapUpdateIntervalMS;
    private final MessageBuffer<Message> buffer;
    private final AtomicLong lastUpdate;
    private List<FutureGCM> pendingRequests;

    public AndroidForwarderRPC(Peer peer, PeerAddress unreachablePeer, MessageBufferConfiguration bufferConfig, String registrationId, IGCMSender sender, int mapUpdateIntervalS) {
        super(peer, unreachablePeer, RelayType.ANDROID);
        this.registrationId = registrationId;
        this.sender = sender;
        this.mapUpdateIntervalMS = (int)((double)(mapUpdateIntervalS * 1000) * 1.5);
        this.lastUpdate = new AtomicLong(System.currentTimeMillis());
        this.pendingRequests = Collections.synchronizedList(new ArrayList());
        this.buffer = new MessageBuffer(bufferConfig);
        this.addBufferListener(this);
    }

    public void addBufferListener(MessageBufferListener<Message> listener) {
        this.buffer.addListener(listener);
    }

    @Override
    public FutureDone<Message> forwardToUnreachable(Message message) {
        FutureDone futureDone = new FutureDone();
        Message response = this.createResponseMessage(message, Message.Type.PARTIALLY_OK);
        response.recipient(message.sender());
        response.sender(this.unreachablePeerAddress());
        try {
            int messageSize = RelayUtils.getMessageSize(message, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
            this.buffer.addMessage(message, messageSize);
        }
        catch (Exception e) {
            LOG.error("Cannot encode the message", (Throwable)e);
            return futureDone.done((Object)this.createResponseMessage(message, Message.Type.EXCEPTION));
        }
        LOG.debug("Added message {} to buffer and returning a partially ok", (Object)message);
        return futureDone.done((Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferFull(List<Message> messages) {
        FutureGCM futureGCM = new FutureGCM(messages, this.registrationId, this.relayPeerId());
        List<FutureGCM> list = this.pendingRequests;
        synchronized (list) {
            this.pendingRequests.add(futureGCM);
        }
        this.sender.send(futureGCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer collectBufferedMessages() {
        this.lastUpdate.set(System.currentTimeMillis());
        ArrayList<Message> messages = new ArrayList<Message>();
        List<FutureGCM> list = this.pendingRequests;
        synchronized (list) {
            for (FutureGCM futureGCM : this.pendingRequests) {
                messages.addAll(futureGCM.buffer());
                futureGCM.done();
            }
            this.pendingRequests.clear();
        }
        ByteBuf byteBuffer = RelayUtils.composeMessageBuffer(messages, this.connectionBean().channelServer().channelServerConfiguration().signatureFactory());
        return new Buffer(byteBuffer);
    }

    @Override
    protected void peerMapUpdated() {
        this.lastUpdate.set(System.currentTimeMillis());
        LOG.trace("Timeout for {} refreshed", (Object)this.registrationId);
    }

    @Override
    protected boolean isAlive() {
        if (this.lastUpdate.get() + (long)this.mapUpdateIntervalMS > System.currentTimeMillis()) {
            LOG.trace("Device {} seems to be alive", (Object)this.registrationId);
            return true;
        }
        LOG.warn("Device {} did not send any messages for a long time", (Object)this.registrationId);
        return false;
    }

    public void changeGCMServers(Collection<PeerAddress> gcmServers) {
        if (this.sender instanceof RemoteGCMSender) {
            RemoteGCMSender remoteGCMSender = (RemoteGCMSender)this.sender;
            remoteGCMSender.gcmServers(gcmServers);
            LOG.debug("Received update of the GCM servers");
        }
    }
}

