/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.nat.PeerNAT;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RconRPC;
import net.tomp2p.relay.RelayRPC;

public class PeerBuilderNAT {
    private final Peer peer;
    private boolean manualPorts = false;
    private Collection<PeerAddress> manualRelays;
    private int failedRelayWaitTime = -1;
    private int maxFail = -1;
    private int peerMapUpdateInterval = -1;

    public PeerBuilderNAT(Peer peer) {
        this.peer = peer;
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public PeerBuilderNAT manualPorts() {
        return this.manualPorts(true);
    }

    public PeerBuilderNAT manualPorts(boolean manualPorts) {
        this.manualPorts = manualPorts;
        return this;
    }

    public Collection<PeerAddress> manualRelays() {
        return this.manualRelays;
    }

    public PeerBuilderNAT relays(Collection<PeerAddress> manualRelays) {
        this.manualRelays = manualRelays;
        return this;
    }

    public PeerBuilderNAT failedRelayWaitTime(int failedRelayWaitTime) {
        this.failedRelayWaitTime = failedRelayWaitTime;
        return this;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public PeerBuilderNAT maxFail(int maxFail) {
        this.maxFail = maxFail;
        return this;
    }

    public int maxFail() {
        return this.maxFail;
    }

    public PeerBuilderNAT peerMapUpdateInterval(int peerMapUpdateInterval) {
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        return this;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public PeerNAT start() {
        final NATUtils natUtils = new NATUtils();
        RconRPC rconRPC = new RconRPC(this.peer);
        RelayRPC relayRPC = new RelayRPC(this.peer, rconRPC);
        if (this.failedRelayWaitTime == -1) {
            this.failedRelayWaitTime = 60;
        }
        if (this.maxFail == -1) {
            this.maxFail = 2;
        }
        if (this.peerMapUpdateInterval == -1) {
            this.peerMapUpdateInterval = 5;
        }
        if (this.manualRelays == null) {
            this.manualRelays = new ArrayList<PeerAddress>(1);
        }
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                natUtils.shutdown();
                return new FutureDone().done();
            }
        });
        return new PeerNAT(this.peer, natUtils, relayRPC, this.manualRelays, this.failedRelayWaitTime, this.maxFail, this.peerMapUpdateInterval, this.manualPorts);
    }
}

