/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.ConcurrentCacheSet;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRelay {
    static final Logger LOG = LoggerFactory.getLogger(DistributedRelay.class);
    private final Peer peer;
    private final RelayRPC relayRPC;
    private final Collection<PeerConnection> relayAddresses;
    private final Collection<PeerAddress> failedRelays;
    private final Collection<RelayListener> relayListeners = new ArrayList<RelayListener>(1);
    private final FutureChannelCreator futureChannelCreator;

    public DistributedRelay(Peer peer, RelayRPC relayRPC, int failedRelayWaitTime) {
        this.peer = peer;
        this.relayRPC = relayRPC;
        this.relayAddresses = Collections.synchronizedList(new ArrayList());
        this.failedRelays = new ConcurrentCacheSet<PeerAddress>(failedRelayWaitTime);
        this.futureChannelCreator = peer.connectionBean().reservation().create(0, 5);
    }

    public Peer peer() {
        return this.peer;
    }

    public Collection<PeerConnection> relayAddresses() {
        return this.relayAddresses;
    }

    public DistributedRelay addRelayListener(RelayListener relayListener) {
        this.relayListeners.add(relayListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureDone<Void>> shutdown() {
        AtomicReferenceArray<FutureDone> futureDones2;
        Collection<PeerConnection> collection = this.relayAddresses;
        synchronized (collection) {
            FutureDone[] futureDones = new FutureDone[this.relayAddresses.size() + 1];
            futureDones2 = new AtomicReferenceArray<FutureDone>(futureDones);
            int i = 1;
            for (PeerConnection peerConnection : this.relayAddresses) {
                futureDones2.set(i++, peerConnection.close());
            }
        }
        final FutureDone futureChannelShutdown = new FutureDone();
        futureDones2.set(0, futureChannelShutdown);
        DistributedRelay distributedRelay = this;
        synchronized (distributedRelay) {
            this.relayListeners.clear();
        }
        this.futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                future.channelCreator().shutdown().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                    public void operationComplete(FutureDone<Void> future) throws Exception {
                        futureChannelShutdown.done();
                    }
                });
            }
        });
        return new FutureForkJoin(futureDones2);
    }

    public FutureRelay setupRelays(final FutureRelay futureRelay, final Collection<PeerAddress> manualRelays, final int maxFail) {
        this.futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    List relayCandidates;
                    ChannelCreator cc = future.channelCreator();
                    if (manualRelays.isEmpty()) {
                        relayCandidates = DistributedRelay.this.peer.distributedRouting().peerMap().all();
                        relayCandidates.removeAll(DistributedRelay.this.failedRelays);
                    } else {
                        relayCandidates = new ArrayList(manualRelays);
                    }
                    DistributedRelay.this.filter(relayCandidates);
                    DistributedRelay.this.setupPeerConnections(futureRelay, cc, relayCandidates, maxFail);
                } else {
                    futureRelay.failed((BaseFuture)future);
                }
            }
        });
        return futureRelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filter(Collection<PeerAddress> relayCandidates) {
        Iterator<PeerAddress> iterator = relayCandidates.iterator();
        while (iterator.hasNext()) {
            PeerAddress pa = iterator.next();
            if (pa.isRelayed()) {
                iterator.remove();
                continue;
            }
            Collection<PeerConnection> collection = this.relayAddresses;
            synchronized (collection) {
                for (PeerConnection pc : this.relayAddresses) {
                    if (!pc.remotePeer().equals((Object)pa)) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        LOG.debug("Found {} peers that could act as relays", (Object)relayCandidates.size());
    }

    private void setupPeerConnections(FutureRelay futureRelay, ChannelCreator cc, Collection<PeerAddress> relayCandidates, int maxFail) {
        int nrOfRelays = Math.min(5 - this.relayAddresses.size(), relayCandidates.size());
        LOG.debug("setting up {} relays", (Object)nrOfRelays);
        if (nrOfRelays > 0) {
            FutureDone[] futureDones = new FutureDone[nrOfRelays];
            AtomicReferenceArray<FutureDone<PeerConnection>> relayConnectionFutures = new AtomicReferenceArray<FutureDone<PeerConnection>>(futureDones);
            this.setupPeerConnectionsRecursive(relayConnectionFutures, relayCandidates, cc, nrOfRelays, futureRelay, 0, maxFail, new StringBuilder());
        } else if (relayCandidates.size() == 0) {
            futureRelay.failed("done");
        } else {
            futureRelay.done(Collections.<PeerConnection>emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPeerConnectionsRecursive(final AtomicReferenceArray<FutureDone<PeerConnection>> futures, final Collection<PeerAddress> relayCandidates, final ChannelCreator cc, final int numberOfRelays, final FutureRelay futureRelay, final int fail, final int maxFail, final StringBuilder status) {
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures.get(i) == null) {
                PeerAddress candidate = null;
                Collection<PeerAddress> collection = relayCandidates;
                synchronized (collection) {
                    if (!relayCandidates.isEmpty()) {
                        candidate = relayCandidates.iterator().next();
                        relayCandidates.remove(candidate);
                    }
                }
                if (candidate == null) continue;
                FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
                FutureDone<PeerConnection> futureDone = this.relayRPC.setupRelay(cc, fpc);
                this.setupAddRealys(fpc.remotePeer(), futureDone);
                futures.set(i, futureDone);
                ++active;
                continue;
            }
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureRelay.failed("no candidates: " + status.toString());
            return;
        }
        if (fail > maxFail) {
            this.updatePeerAddress();
            futureRelay.failed("maxfail: " + status.toString());
            return;
        }
        FutureForkJoin ffj = new FutureForkJoin(active, false, futures);
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> futureForkJoin) throws Exception {
                if (futureForkJoin.isSuccess()) {
                    DistributedRelay.this.updatePeerAddress();
                    Collection collection = DistributedRelay.this.relayAddresses;
                    synchronized (collection) {
                        futureRelay.done(new ArrayList<PeerConnection>(DistributedRelay.this.relayAddresses));
                    }
                } else if (!DistributedRelay.this.peer.isShutdown()) {
                    DistributedRelay.this.setupPeerConnectionsRecursive(futures, relayCandidates, cc, numberOfRelays, futureRelay, fail + 1, maxFail, status.append(futureForkJoin.failedReason()).append(" "));
                } else {
                    futureRelay.failed((BaseFuture)futureForkJoin);
                }
            }
        });
    }

    private void setupAddRealys(final PeerAddress remotePeer, final FutureDone<PeerConnection> futureDone) {
        futureDone.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<PeerConnection>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(FutureDone<PeerConnection> future) throws Exception {
                if (future.isSuccess()) {
                    PeerConnection peerConnection = (PeerConnection)future.object();
                    PeerAddress relayAddress = peerConnection.remotePeer();
                    Collection collection = DistributedRelay.this.relayAddresses;
                    synchronized (collection) {
                        if (DistributedRelay.this.relayAddresses.size() >= 5) {
                            return;
                        }
                        LOG.debug("Adding peer {} as a relay", (Object)relayAddress);
                        DistributedRelay.this.relayAddresses.add(peerConnection);
                    }
                    DistributedRelay.this.addCloseListener(peerConnection);
                } else {
                    LOG.debug("Peer {} denied relay request", (Object)remotePeer);
                    DistributedRelay.this.failedRelays.add(remotePeer);
                    futureDone.failed(future);
                }
            }
        });
    }

    private void addCloseListener(final PeerConnection peerConnection) {
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(FutureDone<Void> future) throws Exception {
                if (!DistributedRelay.this.peer.isShutdown()) {
                    PeerAddress failedRelay = peerConnection.remotePeer();
                    LOG.debug("Relay " + failedRelay + " failed, setting up a new relay peer");
                    DistributedRelay.this.relayAddresses.remove(peerConnection);
                    DistributedRelay.this.failedRelays.add(failedRelay);
                    DistributedRelay.this.updatePeerAddress();
                    5 var3_3 = this;
                    synchronized (var3_3) {
                        for (RelayListener relayListener : DistributedRelay.this.relayListeners) {
                            relayListener.relayFailed(DistributedRelay.this, peerConnection);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePeerAddress() {
        boolean hasRelays = !this.relayAddresses.isEmpty();
        ArrayList<PeerSocketAddress> socketAddresses = new ArrayList<PeerSocketAddress>(this.relayAddresses.size());
        Collection<PeerConnection> collection = this.relayAddresses;
        synchronized (collection) {
            for (PeerConnection pc : this.relayAddresses) {
                PeerAddress pa = pc.remotePeer();
                socketAddresses.add(new PeerSocketAddress(pa.inetAddress(), pa.tcpPort(), pa.udpPort()));
            }
        }
        PeerAddress newAddress = this.peer.peerAddress().changeFirewalledTCP(!hasRelays).changeFirewalledUDP(!hasRelays).changeRelayed(hasRelays).changePeerSocketAddresses(socketAddresses);
        this.peer.peerBean().serverPeerAddress(newAddress);
        LOG.debug("update peer address {}, isrelay = {}", (Object)newAddress, (Object)hasRelays);
    }
}

